/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.index;

import java.time.Duration;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.bson.Document;
import org.jspecify.annotations.Nullable;
import org.springframework.data.mongodb.core.index.Index;
import org.springframework.data.mongodb.core.mapping.FieldName;
import org.springframework.lang.Contract;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class WildcardIndex
extends Index {
    private @Nullable String fieldName;
    private final Map<String, Object> wildcardProjection = new LinkedHashMap<String, Object>();

    public WildcardIndex() {
    }

    public WildcardIndex(@Nullable String path) {
        this.fieldName = path;
    }

    @Contract(value="-> this")
    public WildcardIndex includeId() {
        this.wildcardProjection.put(FieldName.ID.name(), 1);
        return this;
    }

    @Override
    @Contract(value="_ -> this")
    public WildcardIndex named(String name) {
        super.named(name);
        return this;
    }

    @Override
    @Contract(value="-> fail")
    public Index unique() {
        throw new UnsupportedOperationException("Wildcard Index does not support 'unique'");
    }

    @Override
    @Contract(value="-> fail")
    public Index expire(long seconds) {
        throw new UnsupportedOperationException("Wildcard Index does not support 'ttl'");
    }

    @Override
    @Contract(value="_, _ -> fail")
    public Index expire(long value, TimeUnit timeUnit) {
        throw new UnsupportedOperationException("Wildcard Index does not support 'ttl'");
    }

    @Override
    @Contract(value="_ -> fail")
    public Index expire(Duration duration) {
        throw new UnsupportedOperationException("Wildcard Index does not support 'ttl'");
    }

    @Contract(value="_ -> this")
    public WildcardIndex wildcardProjectionInclude(String ... paths) {
        for (String path : paths) {
            this.wildcardProjection.put(path, 1);
        }
        return this;
    }

    @Contract(value="_ -> this")
    public WildcardIndex wildcardProjectionExclude(String ... paths) {
        for (String path : paths) {
            this.wildcardProjection.put(path, 0);
        }
        return this;
    }

    @Contract(value="_ -> this")
    public WildcardIndex wildcardProjection(Map<String, Object> includeExclude) {
        this.wildcardProjection.putAll(includeExclude);
        return this;
    }

    private String getTargetFieldName() {
        return StringUtils.hasText((String)this.fieldName) ? this.fieldName + ".$**" : "$**";
    }

    @Override
    public Document getIndexKeys() {
        return new Document(this.getTargetFieldName(), (Object)1);
    }

    @Override
    public Document getIndexOptions() {
        Document options = new Document((Map)super.getIndexOptions());
        if (!CollectionUtils.isEmpty(this.wildcardProjection)) {
            options.put("wildcardProjection", (Object)new Document(this.wildcardProjection));
        }
        return options;
    }
}

