/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.aggregation;

import org.jspecify.annotations.Nullable;
import org.springframework.data.mongodb.core.aggregation.Field;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

public interface AggregationVariable
extends Field {
    public static final String PREFIX = "$$";

    @Override
    default public boolean isAliased() {
        return !ObjectUtils.nullSafeEquals((Object)this.getName(), (Object)this.getTarget());
    }

    @Override
    default public String getName() {
        return this.getTarget();
    }

    @Override
    default public boolean isInternal() {
        return false;
    }

    public static AggregationVariable variable(final String value) {
        Assert.notNull((Object)value, (String)"Value must not be null");
        return new AggregationVariable(){
            private final String val;
            {
                this.val = AggregationVariable.prefixVariable(value);
            }

            @Override
            public String getTarget() {
                return this.val;
            }
        };
    }

    public static AggregationVariable localVariable(final String value) {
        Assert.notNull((Object)value, (String)"Value must not be null");
        return new AggregationVariable(){
            private final String val;
            {
                this.val = AggregationVariable.prefixVariable(value);
            }

            @Override
            public String getTarget() {
                return this.val;
            }

            @Override
            public boolean isInternal() {
                return true;
            }
        };
    }

    public static boolean isVariable(@Nullable String fieldRef) {
        return fieldRef != null && fieldRef.stripLeading().matches("^\\$\\$\\w.*");
    }

    public static boolean isVariable(Field field) {
        if (field instanceof AggregationVariable) {
            return true;
        }
        return AggregationVariable.isVariable(field.getTarget());
    }

    private static String prefixVariable(String variable) {
        String trimmed = variable.stripLeading();
        return trimmed.startsWith(PREFIX) ? trimmed : PREFIX + trimmed;
    }
}

