/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.query;

import java.util.ArrayList;
import java.util.List;
import org.bson.Document;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Term;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public class TextCriteria
implements CriteriaDefinition {
    private final List<Term> terms;
    @Nullable
    private final String language;
    @Nullable
    private Boolean caseSensitive;
    @Nullable
    private Boolean diacriticSensitive;

    public TextCriteria() {
        this(null);
    }

    private TextCriteria(@Nullable String language) {
        this.language = language;
        this.terms = new ArrayList<Term>();
    }

    public static TextCriteria forDefaultLanguage() {
        return new TextCriteria();
    }

    public static TextCriteria forLanguage(String language) {
        Assert.hasText((String)language, (String)"Language must not be null or empty");
        return new TextCriteria(language);
    }

    public TextCriteria matchingAny(String ... words) {
        for (String word : words) {
            this.matching(word);
        }
        return this;
    }

    public TextCriteria matching(Term term) {
        Assert.notNull((Object)term, (String)"Term to add must not be null");
        this.terms.add(term);
        return this;
    }

    public TextCriteria matching(String term) {
        if (StringUtils.hasText((String)term)) {
            this.matching(new Term(term));
        }
        return this;
    }

    public TextCriteria notMatching(String term) {
        if (StringUtils.hasText((String)term)) {
            this.matching(new Term(term, Term.Type.WORD).negate());
        }
        return this;
    }

    public TextCriteria notMatchingAny(String ... words) {
        for (String word : words) {
            this.notMatching(word);
        }
        return this;
    }

    public TextCriteria notMatchingPhrase(String phrase) {
        if (StringUtils.hasText((String)phrase)) {
            this.matching(new Term(phrase, Term.Type.PHRASE).negate());
        }
        return this;
    }

    public TextCriteria matchingPhrase(String phrase) {
        if (StringUtils.hasText((String)phrase)) {
            this.matching(new Term(phrase, Term.Type.PHRASE));
        }
        return this;
    }

    public TextCriteria caseSensitive(boolean caseSensitive) {
        this.caseSensitive = caseSensitive;
        return this;
    }

    public TextCriteria diacriticSensitive(boolean diacriticSensitive) {
        this.diacriticSensitive = diacriticSensitive;
        return this;
    }

    @Override
    public String getKey() {
        return "$text";
    }

    @Override
    public Document getCriteriaObject() {
        Document document = new Document();
        if (StringUtils.hasText((String)this.language)) {
            document.put("$language", (Object)this.language);
        }
        if (!this.terms.isEmpty()) {
            document.put("$search", (Object)this.join(this.terms));
        }
        if (this.caseSensitive != null) {
            document.put("$caseSensitive", (Object)this.caseSensitive);
        }
        if (this.diacriticSensitive != null) {
            document.put("$diacriticSensitive", (Object)this.diacriticSensitive);
        }
        return new Document("$text", (Object)document);
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TextCriteria)) {
            return false;
        }
        TextCriteria that = (TextCriteria)o;
        return ObjectUtils.nullSafeEquals(this.terms, that.terms) && ObjectUtils.nullSafeEquals((Object)this.language, (Object)that.language) && ObjectUtils.nullSafeEquals((Object)this.caseSensitive, (Object)that.caseSensitive) && ObjectUtils.nullSafeEquals((Object)this.diacriticSensitive, (Object)that.diacriticSensitive);
    }

    public int hashCode() {
        int result = 17;
        result += ObjectUtils.nullSafeHashCode(this.terms);
        result += ObjectUtils.nullSafeHashCode((Object)this.language);
        result += ObjectUtils.nullSafeHashCode((Object)this.caseSensitive);
        return result += ObjectUtils.nullSafeHashCode((Object)this.diacriticSensitive);
    }

    private String join(Iterable<Term> terms) {
        ArrayList<String> result = new ArrayList<String>();
        for (Term term : terms) {
            if (term == null) continue;
            result.add(term.getFormatted());
        }
        return StringUtils.collectionToDelimitedString(result, (String)" ");
    }
}

