/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core;

import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.mongodb.core.aggregation.Aggregation;
import org.springframework.data.mongodb.core.aggregation.AggregationOperationContext;
import org.springframework.data.mongodb.core.aggregation.AggregationOptions;
import org.springframework.data.mongodb.core.aggregation.RelaxedTypeBasedAggregationOperationContext;
import org.springframework.data.mongodb.core.aggregation.TypeBasedAggregationOperationContext;
import org.springframework.data.mongodb.core.aggregation.TypedAggregation;
import org.springframework.data.mongodb.core.convert.QueryMapper;
import org.springframework.data.mongodb.core.mapping.MongoPersistentEntity;
import org.springframework.data.mongodb.core.mapping.MongoPersistentProperty;
import org.springframework.data.util.Lazy;
import org.springframework.lang.Nullable;

class AggregationUtil {
    QueryMapper queryMapper;
    MappingContext<? extends MongoPersistentEntity<?>, MongoPersistentProperty> mappingContext;
    Lazy<AggregationOperationContext> untypedMappingContext;

    AggregationUtil(QueryMapper queryMapper, MappingContext<? extends MongoPersistentEntity<?>, MongoPersistentProperty> mappingContext) {
        this.queryMapper = queryMapper;
        this.mappingContext = mappingContext;
        this.untypedMappingContext = Lazy.of(() -> new RelaxedTypeBasedAggregationOperationContext(Object.class, mappingContext, queryMapper));
    }

    AggregationOperationContext createAggregationContext(Aggregation aggregation, @Nullable Class<?> inputType) {
        AggregationOptions.DomainTypeMapping domainTypeMapping = aggregation.getOptions().getDomainTypeMapping();
        if (domainTypeMapping == AggregationOptions.DomainTypeMapping.NONE) {
            return Aggregation.DEFAULT_CONTEXT;
        }
        if (!(aggregation instanceof TypedAggregation)) {
            if (inputType == null) {
                return (AggregationOperationContext)this.untypedMappingContext.get();
            }
            if (domainTypeMapping == AggregationOptions.DomainTypeMapping.STRICT && !aggregation.getPipeline().containsUnionWith()) {
                return new TypeBasedAggregationOperationContext(inputType, this.mappingContext, this.queryMapper);
            }
            return new RelaxedTypeBasedAggregationOperationContext(inputType, this.mappingContext, this.queryMapper);
        }
        inputType = ((TypedAggregation)aggregation).getInputType();
        if (domainTypeMapping == AggregationOptions.DomainTypeMapping.STRICT && !aggregation.getPipeline().containsUnionWith()) {
            return new TypeBasedAggregationOperationContext(inputType, this.mappingContext, this.queryMapper);
        }
        return new RelaxedTypeBasedAggregationOperationContext(inputType, this.mappingContext, this.queryMapper);
    }

    List<Document> createPipeline(Aggregation aggregation, AggregationOperationContext context) {
        return aggregation.toPipeline(context);
    }

    Document createCommand(String collection, Aggregation aggregation, AggregationOperationContext context) {
        return aggregation.toDocument(collection, context);
    }

    private List<Document> mapAggregationPipeline(List<Document> pipeline) {
        return pipeline.stream().map(val -> this.queryMapper.getMappedObject((Bson)val, Optional.empty())).collect(Collectors.toList());
    }
}

