/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb;

import com.mongodb.MongoDriverInformation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.util.Version;
import org.springframework.util.StringUtils;

public class SpringDataMongoDB {
    private static final Logger LOGGER = LoggerFactory.getLogger(SpringDataMongoDB.class);
    private static final Version FALLBACK_VERSION = new Version(new int[]{3});
    private static final MongoDriverInformation DRIVER_INFORMATION = MongoDriverInformation.builder((MongoDriverInformation)MongoDriverInformation.builder().build()).driverName("spring-data").build();

    public static MongoDriverInformation driverInformation() {
        return DRIVER_INFORMATION;
    }

    public static Version version() {
        String versionString;
        Package pkg = SpringDataMongoDB.class.getPackage();
        String string = versionString = pkg != null ? pkg.getImplementationVersion() : null;
        if (!StringUtils.hasText((String)versionString)) {
            LOGGER.debug("Unable to find Spring Data MongoDB version.");
            return FALLBACK_VERSION;
        }
        try {
            return Version.parse((String)versionString);
        }
        catch (Exception e) {
            LOGGER.debug("Cannot read Spring Data MongoDB version '{}'.", (Object)versionString);
            return FALLBACK_VERSION;
        }
    }
}

