/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.repository.query;

import org.bson.Document;
import org.bson.json.JsonParseException;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.mongodb.core.ReactiveMongoOperations;
import org.springframework.data.mongodb.core.mapping.MongoPersistentProperty;
import org.springframework.data.mongodb.core.query.BasicQuery;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.TextCriteria;
import org.springframework.data.mongodb.repository.query.AbstractReactiveMongoQuery;
import org.springframework.data.mongodb.repository.query.ConvertingParameterAccessor;
import org.springframework.data.mongodb.repository.query.MongoQueryCreator;
import org.springframework.data.mongodb.repository.query.ReactiveMongoQueryMethod;
import org.springframework.data.repository.query.ParameterAccessor;
import org.springframework.data.repository.query.ReactiveQueryMethodEvaluationContextProvider;
import org.springframework.data.repository.query.ResultProcessor;
import org.springframework.data.repository.query.ReturnedType;
import org.springframework.data.repository.query.parser.PartTree;
import org.springframework.expression.ExpressionParser;
import org.springframework.util.StringUtils;
import reactor.core.publisher.Mono;

public class ReactivePartTreeMongoQuery
extends AbstractReactiveMongoQuery {
    private final PartTree tree;
    private final boolean isGeoNearQuery;
    private final MappingContext<?, MongoPersistentProperty> context;
    private final ResultProcessor processor;

    public ReactivePartTreeMongoQuery(ReactiveMongoQueryMethod method, ReactiveMongoOperations mongoOperations, ExpressionParser expressionParser, ReactiveQueryMethodEvaluationContextProvider evaluationContextProvider) {
        super(method, mongoOperations, expressionParser, evaluationContextProvider);
        this.processor = method.getResultProcessor();
        this.tree = new PartTree(method.getName(), this.processor.getReturnedType().getDomainType());
        this.isGeoNearQuery = method.isGeoNearQuery();
        this.context = mongoOperations.getConverter().getMappingContext();
    }

    public PartTree getTree() {
        return this.tree;
    }

    @Override
    protected Mono<Query> createQuery(ConvertingParameterAccessor accessor) {
        return Mono.fromSupplier(() -> this.createQueryInternal(accessor, false));
    }

    @Override
    protected Mono<Query> createCountQuery(ConvertingParameterAccessor accessor) {
        return Mono.fromSupplier(() -> this.createQueryInternal(accessor, true));
    }

    private Query createQueryInternal(ConvertingParameterAccessor accessor, boolean isCountQuery) {
        String fieldSpec;
        TextCriteria textCriteria;
        MongoQueryCreator creator = new MongoQueryCreator(this.tree, accessor, this.context, isCountQuery ? false : this.isGeoNearQuery);
        Query query = (Query)creator.createQuery();
        if (isCountQuery) {
            return query;
        }
        if (this.tree.isLimiting()) {
            query.limit(this.tree.getMaxResults());
        }
        if ((textCriteria = accessor.getFullText()) != null) {
            query.addCriteria(textCriteria);
        }
        if (!StringUtils.hasText((String)(fieldSpec = this.getQueryMethod().getFieldSpecification()))) {
            ReturnedType returnedType = this.processor.withDynamicProjection((ParameterAccessor)accessor).getReturnedType();
            if (returnedType.isProjecting()) {
                returnedType.getInputProperties().forEach(query.fields()::include);
            }
            return query;
        }
        try {
            BasicQuery result = new BasicQuery(query.getQueryObject(), Document.parse((String)fieldSpec));
            result.setSortObject(query.getSortObject());
            return result;
        }
        catch (JsonParseException o_O) {
            throw new IllegalStateException(String.format("Invalid query or field specification in %s!", new Object[]{this.getQueryMethod()}), o_O);
        }
    }

    @Override
    protected boolean isCountQuery() {
        return this.tree.isCountProjection();
    }

    @Override
    protected boolean isExistsQuery() {
        return this.tree.isExistsProjection();
    }

    @Override
    protected boolean isDeleteQuery() {
        return this.tree.isDelete();
    }

    @Override
    protected boolean isLimiting() {
        return this.tree.isLimiting();
    }
}

