/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core;

import java.util.Collection;
import lombok.NonNull;
import org.springframework.data.mongodb.core.ReactiveInsertOperation;
import org.springframework.data.mongodb.core.ReactiveMongoTemplate;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

class ReactiveInsertOperationSupport
implements ReactiveInsertOperation {
    @NonNull
    private final ReactiveMongoTemplate template;

    @Override
    public <T> ReactiveInsertOperation.ReactiveInsert<T> insert(Class<T> domainType) {
        Assert.notNull(domainType, (String)"DomainType must not be null!");
        return new ReactiveInsertSupport<T>(this.template, domainType, null);
    }

    public ReactiveInsertOperationSupport(@NonNull ReactiveMongoTemplate template) {
        if (template == null) {
            throw new IllegalArgumentException("template is marked @NonNull but is null");
        }
        this.template = template;
    }

    static class ReactiveInsertSupport<T>
    implements ReactiveInsertOperation.ReactiveInsert<T> {
        @NonNull
        private final ReactiveMongoTemplate template;
        @NonNull
        private final Class<T> domainType;
        private final String collection;

        @Override
        public Mono<T> one(T object) {
            Assert.notNull(object, (String)"Object must not be null!");
            return this.template.insert(object, this.getCollectionName());
        }

        @Override
        public Flux<T> all(Collection<? extends T> objects) {
            Assert.notNull(objects, (String)"Objects must not be null!");
            return this.template.insert(objects, this.getCollectionName());
        }

        @Override
        public ReactiveInsertOperation.ReactiveInsert<T> inCollection(String collection) {
            Assert.hasText((String)collection, (String)"Collection must not be null nor empty.");
            return new ReactiveInsertSupport<T>(this.template, this.domainType, collection);
        }

        private String getCollectionName() {
            return StringUtils.hasText((String)this.collection) ? this.collection : this.template.getCollectionName(this.domainType);
        }

        public ReactiveInsertSupport(@NonNull ReactiveMongoTemplate template, @NonNull Class<T> domainType, String collection) {
            if (template == null) {
                throw new IllegalArgumentException("template is marked @NonNull but is null");
            }
            if (domainType == null) {
                throw new IllegalArgumentException("domainType is marked @NonNull but is null");
            }
            this.template = template;
            this.domainType = domainType;
            this.collection = collection;
        }
    }
}

