/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.config;

import org.springframework.beans.factory.BeanDefinitionStoreException;
import org.springframework.beans.factory.parsing.BeanComponentDefinition;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.AbstractBeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.data.config.BeanComponentDefinitionBuilder;
import org.springframework.data.config.ParsingUtils;
import org.springframework.data.mongodb.config.MongoParsingUtils;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;

class MongoTemplateParser
extends AbstractBeanDefinitionParser {
    MongoTemplateParser() {
    }

    protected String resolveId(Element element, AbstractBeanDefinition definition, ParserContext parserContext) throws BeanDefinitionStoreException {
        String id = super.resolveId(element, definition, parserContext);
        return StringUtils.hasText((String)id) ? id : "mongoTemplate";
    }

    protected AbstractBeanDefinition parseInternal(Element element, ParserContext parserContext) {
        BeanComponentDefinitionBuilder helper = new BeanComponentDefinitionBuilder(element, parserContext);
        String converterRef = element.getAttribute("converter-ref");
        String dbFactoryRef = element.getAttribute("db-factory-ref");
        BeanDefinitionBuilder mongoTemplateBuilder = BeanDefinitionBuilder.genericBeanDefinition(MongoTemplate.class);
        ParsingUtils.setPropertyValue((BeanDefinitionBuilder)mongoTemplateBuilder, (Element)element, (String)"write-concern", (String)"writeConcern");
        if (StringUtils.hasText((String)dbFactoryRef)) {
            mongoTemplateBuilder.addConstructorArgReference(dbFactoryRef);
        } else {
            mongoTemplateBuilder.addConstructorArgReference("mongoDbFactory");
        }
        if (StringUtils.hasText((String)converterRef)) {
            mongoTemplateBuilder.addConstructorArgReference(converterRef);
        }
        BeanDefinitionBuilder writeConcernPropertyEditorBuilder = MongoParsingUtils.getWriteConcernPropertyEditorBuilder();
        BeanComponentDefinition component = helper.getComponent(writeConcernPropertyEditorBuilder);
        parserContext.registerBeanComponent(component);
        return (AbstractBeanDefinition)helper.getComponentIdButFallback(mongoTemplateBuilder, "mongoTemplate").getBeanDefinition();
    }
}

