/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.convert;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Currency;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.bson.Document;
import org.bson.types.Code;
import org.bson.types.ObjectId;
import org.springframework.core.convert.ConversionFailedException;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.core.convert.converter.ConditionalConverter;
import org.springframework.core.convert.converter.Converter;
import org.springframework.core.convert.converter.ConverterFactory;
import org.springframework.data.convert.ReadingConverter;
import org.springframework.data.convert.WritingConverter;
import org.springframework.data.mongodb.core.query.Term;
import org.springframework.data.mongodb.core.script.NamedMongoScript;
import org.springframework.util.Assert;
import org.springframework.util.NumberUtils;
import org.springframework.util.StringUtils;

abstract class MongoConverters {
    private MongoConverters() {
    }

    public static Collection<Object> getConvertersToRegister() {
        ArrayList<Object> converters = new ArrayList<Object>();
        converters.add((Object)BigDecimalToStringConverter.INSTANCE);
        converters.add((Object)StringToBigDecimalConverter.INSTANCE);
        converters.add((Object)BigIntegerToStringConverter.INSTANCE);
        converters.add((Object)StringToBigIntegerConverter.INSTANCE);
        converters.add((Object)URLToStringConverter.INSTANCE);
        converters.add((Object)StringToURLConverter.INSTANCE);
        converters.add((Object)DocumentToStringConverter.INSTANCE);
        converters.add((Object)TermToStringConverter.INSTANCE);
        converters.add((Object)NamedMongoScriptToDocumentConverter.INSTANCE);
        converters.add((Object)DocumentToNamedMongoScriptConverter.INSTANCE);
        converters.add((Object)CurrencyToStringConverter.INSTANCE);
        converters.add((Object)StringToCurrencyConverter.INSTANCE);
        converters.add((Object)AtomicIntegerToIntegerConverter.INSTANCE);
        converters.add((Object)AtomicLongToLongConverter.INSTANCE);
        converters.add((Object)LongToAtomicLongConverter.INSTANCE);
        converters.add((Object)IntegerToAtomicIntegerConverter.INSTANCE);
        return converters;
    }

    @ReadingConverter
    public static enum IntegerToAtomicIntegerConverter implements Converter<Integer, AtomicInteger>
    {
        INSTANCE;


        public AtomicInteger convert(Integer source) {
            return source != null ? new AtomicInteger(source) : null;
        }
    }

    @ReadingConverter
    public static enum LongToAtomicLongConverter implements Converter<Long, AtomicLong>
    {
        INSTANCE;


        public AtomicLong convert(Long source) {
            return source != null ? new AtomicLong(source) : null;
        }
    }

    @WritingConverter
    public static enum AtomicIntegerToIntegerConverter implements Converter<AtomicInteger, Integer>
    {
        INSTANCE;


        public Integer convert(AtomicInteger source) {
            return (Integer)NumberUtils.convertNumberToTargetClass((Number)source, Integer.class);
        }
    }

    @WritingConverter
    public static enum AtomicLongToLongConverter implements Converter<AtomicLong, Long>
    {
        INSTANCE;


        public Long convert(AtomicLong source) {
            return (Long)NumberUtils.convertNumberToTargetClass((Number)source, Long.class);
        }
    }

    @WritingConverter
    public static enum NumberToNumberConverterFactory implements ConverterFactory<Number, Number>,
    ConditionalConverter
    {
        INSTANCE;


        public <T extends Number> Converter<Number, T> getConverter(Class<T> targetType) {
            return new NumberToNumberConverter<T>(targetType);
        }

        public boolean matches(TypeDescriptor sourceType, TypeDescriptor targetType) {
            return !sourceType.equals((Object)targetType);
        }

        private static final class NumberToNumberConverter<T extends Number>
        implements Converter<Number, T> {
            private final Class<T> targetType;

            public NumberToNumberConverter(Class<T> targetType) {
                Assert.notNull(targetType, (String)"Target type must not be null!");
                this.targetType = targetType;
            }

            public T convert(Number source) {
                if (source instanceof AtomicInteger) {
                    return (T)NumberUtils.convertNumberToTargetClass((Number)((AtomicInteger)source).get(), this.targetType);
                }
                if (source instanceof AtomicLong) {
                    return (T)NumberUtils.convertNumberToTargetClass((Number)((AtomicLong)source).get(), this.targetType);
                }
                return (T)NumberUtils.convertNumberToTargetClass((Number)source, this.targetType);
            }
        }
    }

    @ReadingConverter
    public static enum StringToCurrencyConverter implements Converter<String, Currency>
    {
        INSTANCE;


        public Currency convert(String source) {
            return StringUtils.hasText((String)source) ? Currency.getInstance(source) : null;
        }
    }

    @WritingConverter
    public static enum CurrencyToStringConverter implements Converter<Currency, String>
    {
        INSTANCE;


        public String convert(Currency source) {
            return source == null ? null : source.getCurrencyCode();
        }
    }

    public static enum NamedMongoScriptToDocumentConverter implements Converter<NamedMongoScript, Document>
    {
        INSTANCE;


        public Document convert(NamedMongoScript source) {
            if (source == null) {
                return new Document();
            }
            Document document = new Document();
            document.put("_id", (Object)source.getName());
            document.put("value", (Object)new Code(source.getCode()));
            return document;
        }
    }

    public static enum DocumentToNamedMongoScriptConverter implements Converter<Document, NamedMongoScript>
    {
        INSTANCE;


        public NamedMongoScript convert(Document source) {
            if (source == null) {
                return null;
            }
            String id = source.get((Object)"_id").toString();
            Object rawValue = source.get((Object)"value");
            return new NamedMongoScript(id, ((Code)rawValue).getCode());
        }
    }

    @WritingConverter
    public static enum TermToStringConverter implements Converter<Term, String>
    {
        INSTANCE;


        public String convert(Term source) {
            return source == null ? null : source.getFormatted();
        }
    }

    @ReadingConverter
    public static enum DocumentToStringConverter implements Converter<Document, String>
    {
        INSTANCE;


        public String convert(Document source) {
            if (source == null) {
                return null;
            }
            return source.toJson();
        }
    }

    public static enum StringToURLConverter implements Converter<String, URL>
    {
        INSTANCE;

        private static final TypeDescriptor SOURCE;
        private static final TypeDescriptor TARGET;

        public URL convert(String source) {
            try {
                return source == null ? null : new URL(source);
            }
            catch (MalformedURLException e) {
                throw new ConversionFailedException(SOURCE, TARGET, (Object)source, (Throwable)e);
            }
        }

        static {
            SOURCE = TypeDescriptor.valueOf(String.class);
            TARGET = TypeDescriptor.valueOf(URL.class);
        }
    }

    public static enum URLToStringConverter implements Converter<URL, String>
    {
        INSTANCE;


        public String convert(URL source) {
            return source == null ? null : source.toString();
        }
    }

    public static enum StringToBigIntegerConverter implements Converter<String, BigInteger>
    {
        INSTANCE;


        public BigInteger convert(String source) {
            return StringUtils.hasText((String)source) ? new BigInteger(source) : null;
        }
    }

    public static enum BigIntegerToStringConverter implements Converter<BigInteger, String>
    {
        INSTANCE;


        public String convert(BigInteger source) {
            return source == null ? null : source.toString();
        }
    }

    public static enum StringToBigDecimalConverter implements Converter<String, BigDecimal>
    {
        INSTANCE;


        public BigDecimal convert(String source) {
            return StringUtils.hasText((String)source) ? new BigDecimal(source) : null;
        }
    }

    public static enum BigDecimalToStringConverter implements Converter<BigDecimal, String>
    {
        INSTANCE;


        public String convert(BigDecimal source) {
            return source == null ? null : source.toString();
        }
    }

    public static enum BigIntegerToObjectIdConverter implements Converter<BigInteger, ObjectId>
    {
        INSTANCE;


        public ObjectId convert(BigInteger source) {
            return source == null ? null : new ObjectId(source.toString(16));
        }
    }

    public static enum ObjectIdToBigIntegerConverter implements Converter<ObjectId, BigInteger>
    {
        INSTANCE;


        public BigInteger convert(ObjectId source) {
            return source == null ? null : new BigInteger(source.toString(), 16);
        }
    }

    public static enum StringToObjectIdConverter implements Converter<String, ObjectId>
    {
        INSTANCE;


        public ObjectId convert(String source) {
            return StringUtils.hasText((String)source) ? new ObjectId(source) : null;
        }
    }

    public static enum ObjectIdToStringConverter implements Converter<ObjectId, String>
    {
        INSTANCE;


        public String convert(ObjectId id) {
            return id == null ? null : id.toString();
        }
    }
}

