/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core;

import com.mongodb.client.result.UpdateResult;
import java.beans.ConstructorProperties;
import lombok.NonNull;
import org.springframework.data.mongodb.core.FindAndModifyOptions;
import org.springframework.data.mongodb.core.ReactiveMongoTemplate;
import org.springframework.data.mongodb.core.ReactiveUpdateOperation;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import reactor.core.publisher.Mono;

class ReactiveUpdateOperationSupport
implements ReactiveUpdateOperation {
    private static final Query ALL_QUERY = new Query();
    @NonNull
    private final ReactiveMongoTemplate template;

    @Override
    public <T> ReactiveUpdateOperation.ReactiveUpdate<T> update(Class<T> domainType) {
        Assert.notNull(domainType, (String)"DomainType must not be null!");
        return new ReactiveUpdateSupport<T>(this.template, domainType, ALL_QUERY, null, null, null);
    }

    @ConstructorProperties(value={"template"})
    public ReactiveUpdateOperationSupport(@NonNull ReactiveMongoTemplate template) {
        if (template == null) {
            throw new IllegalArgumentException("template is null");
        }
        this.template = template;
    }

    static class ReactiveUpdateSupport<T>
    implements ReactiveUpdateOperation.ReactiveUpdate<T>,
    ReactiveUpdateOperation.UpdateWithCollection<T>,
    ReactiveUpdateOperation.UpdateWithQuery<T>,
    ReactiveUpdateOperation.TerminatingUpdate<T> {
        @NonNull
        private final ReactiveMongoTemplate template;
        @NonNull
        private final Class<T> domainType;
        private final Query query;
        private final Update update;
        private final String collection;
        private final FindAndModifyOptions options;

        @Override
        public ReactiveUpdateOperation.TerminatingUpdate<T> apply(Update update) {
            Assert.notNull((Object)update, (String)"Update must not be null!");
            return new ReactiveUpdateSupport<T>(this.template, this.domainType, this.query, update, this.collection, this.options);
        }

        @Override
        public ReactiveUpdateOperation.UpdateWithQuery<T> inCollection(String collection) {
            Assert.hasText((String)collection, (String)"Collection must not be null nor empty!");
            return new ReactiveUpdateSupport<T>(this.template, this.domainType, this.query, this.update, collection, this.options);
        }

        @Override
        public Mono<UpdateResult> first() {
            return this.doUpdate(false, false);
        }

        @Override
        public Mono<UpdateResult> upsert() {
            return this.doUpdate(true, true);
        }

        @Override
        public Mono<T> findAndModify() {
            String collectionName = this.getCollectionName();
            return this.template.findAndModify(this.query, this.update, this.options, this.domainType, collectionName);
        }

        @Override
        public ReactiveUpdateOperation.UpdateWithUpdate<T> matching(Query query) {
            Assert.notNull((Object)query, (String)"Query must not be null!");
            return new ReactiveUpdateSupport<T>(this.template, this.domainType, query, this.update, this.collection, this.options);
        }

        @Override
        public Mono<UpdateResult> all() {
            return this.doUpdate(true, false);
        }

        @Override
        public ReactiveUpdateOperation.TerminatingFindAndModify<T> withOptions(FindAndModifyOptions options) {
            Assert.notNull((Object)options, (String)"Options must not be null!");
            return new ReactiveUpdateSupport<T>(this.template, this.domainType, this.query, this.update, this.collection, options);
        }

        private Mono<UpdateResult> doUpdate(boolean multi, boolean upsert) {
            return this.template.doUpdate(this.getCollectionName(), this.query, this.update, this.domainType, upsert, multi);
        }

        private String getCollectionName() {
            return StringUtils.hasText((String)this.collection) ? this.collection : this.template.determineCollectionName(this.domainType);
        }

        @ConstructorProperties(value={"template", "domainType", "query", "update", "collection", "options"})
        public ReactiveUpdateSupport(@NonNull ReactiveMongoTemplate template, @NonNull Class<T> domainType, Query query, Update update, String collection, FindAndModifyOptions options) {
            if (template == null) {
                throw new IllegalArgumentException("template is null");
            }
            if (domainType == null) {
                throw new IllegalArgumentException("domainType is null");
            }
            this.template = template;
            this.domainType = domainType;
            this.query = query;
            this.update = update;
            this.collection = collection;
            this.options = options;
        }
    }
}

