/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.convert;

import com.mongodb.DB;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Method;
import org.aopalliance.aop.Advice;
import org.aopalliance.intercept.MethodInvocation;
import org.objenesis.Objenesis;
import org.objenesis.ObjenesisStd;
import org.springframework.aop.framework.ProxyFactory;
import org.springframework.cglib.proxy.Callback;
import org.springframework.cglib.proxy.Enhancer;
import org.springframework.cglib.proxy.Factory;
import org.springframework.cglib.proxy.MethodInterceptor;
import org.springframework.cglib.proxy.MethodProxy;
import org.springframework.core.SpringVersion;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.support.PersistenceExceptionTranslator;
import org.springframework.data.mongodb.LazyLoadingException;
import org.springframework.data.mongodb.MongoDbFactory;
import org.springframework.data.mongodb.core.convert.DbRefResolver;
import org.springframework.data.mongodb.core.convert.DbRefResolverCallback;
import org.springframework.data.mongodb.core.mapping.DBRef;
import org.springframework.data.mongodb.core.mapping.MongoPersistentEntity;
import org.springframework.data.mongodb.core.mapping.MongoPersistentProperty;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;

public class DefaultDbRefResolver
implements DbRefResolver {
    private static final boolean IS_SPRING_4_OR_BETTER = SpringVersion.getVersion().startsWith("4");
    private static final boolean OBJENESIS_PRESENT = ClassUtils.isPresent((String)"org.objenesis.Objenesis", null);
    private final MongoDbFactory mongoDbFactory;
    private final PersistenceExceptionTranslator exceptionTranslator;

    public DefaultDbRefResolver(MongoDbFactory mongoDbFactory) {
        Assert.notNull((Object)mongoDbFactory, (String)"MongoDbFactory translator must not be null!");
        this.mongoDbFactory = mongoDbFactory;
        this.exceptionTranslator = mongoDbFactory.getExceptionTranslator();
    }

    @Override
    public Object resolveDbRef(MongoPersistentProperty property, DbRefResolverCallback callback) {
        Assert.notNull((Object)property, (String)"Property must not be null!");
        Assert.notNull((Object)callback, (String)"Callback must not be null!");
        if (this.isLazyDbRef(property)) {
            return this.createLazyLoadingProxy(property, callback);
        }
        return callback.resolve(property);
    }

    @Override
    public com.mongodb.DBRef createDbRef(DBRef annotation, MongoPersistentEntity<?> entity, Object id) {
        DB db = this.mongoDbFactory.getDb();
        db = annotation != null && StringUtils.hasText((String)annotation.db()) ? this.mongoDbFactory.getDb(annotation.db()) : db;
        return new com.mongodb.DBRef(db, entity.getCollection(), id);
    }

    private Object createLazyLoadingProxy(MongoPersistentProperty property, DbRefResolverCallback callback) {
        ProxyFactory proxyFactory = new ProxyFactory();
        Class propertyType = property.getType();
        for (Class<?> type : propertyType.getInterfaces()) {
            proxyFactory.addInterface(type);
        }
        LazyLoadingInterceptor interceptor = new LazyLoadingInterceptor(property, this.exceptionTranslator, callback);
        if (propertyType.isInterface()) {
            proxyFactory.addInterface(propertyType);
            proxyFactory.addAdvice((Advice)interceptor);
            return proxyFactory.getProxy();
        }
        proxyFactory.setProxyTargetClass(true);
        proxyFactory.setTargetClass(propertyType);
        if (IS_SPRING_4_OR_BETTER || !OBJENESIS_PRESENT) {
            proxyFactory.addAdvice((Advice)interceptor);
            return proxyFactory.getProxy();
        }
        return ObjenesisProxyEnhancer.enhanceAndGet(proxyFactory, propertyType, interceptor);
    }

    private boolean isLazyDbRef(MongoPersistentProperty property) {
        return property.getDBRef() != null && property.getDBRef().lazy();
    }

    private static class ObjenesisProxyEnhancer {
        private static final Objenesis OBJENESIS = new ObjenesisStd(true);

        private ObjenesisProxyEnhancer() {
        }

        public static Object enhanceAndGet(ProxyFactory proxyFactory, Class<?> type, MethodInterceptor interceptor) {
            Enhancer enhancer = new Enhancer();
            enhancer.setSuperclass(type);
            enhancer.setCallbackType(MethodInterceptor.class);
            Factory factory = (Factory)OBJENESIS.newInstance(enhancer.createClass());
            factory.setCallbacks(new Callback[]{interceptor});
            return factory;
        }
    }

    static class LazyLoadingInterceptor
    implements org.aopalliance.intercept.MethodInterceptor,
    MethodInterceptor,
    Serializable {
        private final DbRefResolverCallback callback;
        private final MongoPersistentProperty property;
        private final PersistenceExceptionTranslator exceptionTranslator;
        private volatile boolean resolved;
        private Object result;

        public LazyLoadingInterceptor(MongoPersistentProperty property, PersistenceExceptionTranslator exceptionTranslator, DbRefResolverCallback callback) {
            Assert.notNull((Object)property, (String)"Property must not be null!");
            Assert.notNull((Object)exceptionTranslator, (String)"Exception translator must not be null!");
            Assert.notNull((Object)callback, (String)"Callback must not be null!");
            this.callback = callback;
            this.exceptionTranslator = exceptionTranslator;
            this.property = property;
        }

        public Object invoke(MethodInvocation invocation) throws Throwable {
            return this.intercept(invocation.getThis(), invocation.getMethod(), invocation.getArguments(), null);
        }

        public Object intercept(Object obj, Method method, Object[] args, MethodProxy proxy) throws Throwable {
            return ReflectionUtils.isObjectMethod((Method)method) ? method.invoke(obj, args) : method.invoke(this.ensureResolved(), args);
        }

        private Object ensureResolved() {
            if (!this.resolved) {
                this.result = this.resolve();
                this.resolved = true;
            }
            return this.result;
        }

        private void writeObject(ObjectOutputStream out) throws IOException {
            this.ensureResolved();
            out.writeObject(this.result);
        }

        private void readObject(ObjectInputStream in) throws IOException {
            try {
                this.resolved = true;
                this.result = in.readObject();
            }
            catch (ClassNotFoundException e) {
                throw new LazyLoadingException("Could not deserialize result", e);
            }
        }

        private synchronized Object resolve() {
            if (!this.resolved) {
                try {
                    return this.callback.resolve(this.property);
                }
                catch (RuntimeException ex) {
                    DataAccessException translatedException = this.exceptionTranslator.translateExceptionIfPossible(ex);
                    throw new LazyLoadingException("Unable to lazily resolve DBRef!", (Throwable)translatedException);
                }
            }
            return this.result;
        }

        public boolean isResolved() {
            return this.resolved;
        }

        public Object getResult() {
            return this.result;
        }
    }
}

