/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core;

import com.mongodb.MongoOptions;
import javax.net.ssl.SSLSocketFactory;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;

public class MongoOptionsFactoryBean
implements FactoryBean<MongoOptions>,
InitializingBean {
    private final MongoOptions MONGO_OPTIONS = new MongoOptions();
    private int connectionsPerHost;
    private int threadsAllowedToBlockForConnectionMultiplier;
    private int maxWaitTime;
    private int connectTimeout;
    private int socketTimeout;
    private boolean socketKeepAlive;
    private boolean autoConnectRetry;
    private long maxAutoConnectRetryTime;
    private int writeNumber;
    private int writeTimeout;
    private boolean writeFsync;
    private boolean slaveOk;
    private boolean ssl;
    private SSLSocketFactory sslSocketFactory;

    public MongoOptionsFactoryBean() {
        this.connectionsPerHost = this.MONGO_OPTIONS.connectionsPerHost;
        this.threadsAllowedToBlockForConnectionMultiplier = this.MONGO_OPTIONS.threadsAllowedToBlockForConnectionMultiplier;
        this.maxWaitTime = this.MONGO_OPTIONS.maxWaitTime;
        this.connectTimeout = this.MONGO_OPTIONS.connectTimeout;
        this.socketTimeout = this.MONGO_OPTIONS.socketTimeout;
        this.socketKeepAlive = this.MONGO_OPTIONS.socketKeepAlive;
        this.autoConnectRetry = this.MONGO_OPTIONS.autoConnectRetry;
        this.maxAutoConnectRetryTime = this.MONGO_OPTIONS.maxAutoConnectRetryTime;
        this.slaveOk = this.MONGO_OPTIONS.slaveOk;
    }

    public void setConnectionsPerHost(int connectionsPerHost) {
        this.connectionsPerHost = connectionsPerHost;
    }

    public void setThreadsAllowedToBlockForConnectionMultiplier(int threadsAllowedToBlockForConnectionMultiplier) {
        this.threadsAllowedToBlockForConnectionMultiplier = threadsAllowedToBlockForConnectionMultiplier;
    }

    public void setMaxWaitTime(int maxWaitTime) {
        this.maxWaitTime = maxWaitTime;
    }

    public void setConnectTimeout(int connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    public void setSocketTimeout(int socketTimeout) {
        this.socketTimeout = socketTimeout;
    }

    public void setSocketKeepAlive(boolean socketKeepAlive) {
        this.socketKeepAlive = socketKeepAlive;
    }

    public void setWriteNumber(int writeNumber) {
        this.writeNumber = writeNumber;
    }

    public void setWriteTimeout(int writeTimeout) {
        this.writeTimeout = writeTimeout;
    }

    public void setWriteFsync(boolean writeFsync) {
        this.writeFsync = writeFsync;
    }

    public void setAutoConnectRetry(boolean autoConnectRetry) {
        this.autoConnectRetry = autoConnectRetry;
    }

    public void setMaxAutoConnectRetryTime(long maxAutoConnectRetryTime) {
        this.maxAutoConnectRetryTime = maxAutoConnectRetryTime;
    }

    public void setSlaveOk(boolean slaveOk) {
        this.slaveOk = slaveOk;
    }

    public void setSsl(boolean ssl) {
        this.ssl = ssl;
    }

    public void setSslSocketFactory(SSLSocketFactory sslSocketFactory) {
        this.setSsl(sslSocketFactory != null);
        this.sslSocketFactory = sslSocketFactory;
    }

    public void afterPropertiesSet() {
        this.MONGO_OPTIONS.connectionsPerHost = this.connectionsPerHost;
        this.MONGO_OPTIONS.threadsAllowedToBlockForConnectionMultiplier = this.threadsAllowedToBlockForConnectionMultiplier;
        this.MONGO_OPTIONS.maxWaitTime = this.maxWaitTime;
        this.MONGO_OPTIONS.connectTimeout = this.connectTimeout;
        this.MONGO_OPTIONS.socketTimeout = this.socketTimeout;
        this.MONGO_OPTIONS.socketKeepAlive = this.socketKeepAlive;
        this.MONGO_OPTIONS.autoConnectRetry = this.autoConnectRetry;
        this.MONGO_OPTIONS.maxAutoConnectRetryTime = this.maxAutoConnectRetryTime;
        this.MONGO_OPTIONS.slaveOk = this.slaveOk;
        this.MONGO_OPTIONS.w = this.writeNumber;
        this.MONGO_OPTIONS.wtimeout = this.writeTimeout;
        this.MONGO_OPTIONS.fsync = this.writeFsync;
        if (this.ssl) {
            this.MONGO_OPTIONS.setSocketFactory(this.sslSocketFactory != null ? this.sslSocketFactory : SSLSocketFactory.getDefault());
        }
    }

    public MongoOptions getObject() {
        return this.MONGO_OPTIONS;
    }

    public Class<?> getObjectType() {
        return MongoOptions.class;
    }

    public boolean isSingleton() {
        return true;
    }
}

