/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.config;

import com.mongodb.ServerAddress;
import java.beans.PropertyEditorSupport;
import java.net.UnknownHostException;
import java.util.HashSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class ServerAddressPropertyEditor
extends PropertyEditorSupport {
    private static final Logger LOG = LoggerFactory.getLogger(ServerAddressPropertyEditor.class);

    @Override
    public void setAsText(String replicaSetString) {
        if (!StringUtils.hasText((String)replicaSetString)) {
            this.setValue(null);
            return;
        }
        String[] replicaSetStringArray = StringUtils.commaDelimitedListToStringArray((String)replicaSetString);
        HashSet<ServerAddress> serverAddresses = new HashSet<ServerAddress>(replicaSetStringArray.length);
        for (String element : replicaSetStringArray) {
            ServerAddress address = this.parseServerAddress(element);
            if (address == null) continue;
            serverAddresses.add(address);
        }
        if (serverAddresses.isEmpty()) {
            throw new IllegalArgumentException("Could not resolve at least one server of the replica set configuration! Validate your config!");
        }
        this.setValue(serverAddresses.toArray(new ServerAddress[serverAddresses.size()]));
    }

    private ServerAddress parseServerAddress(String source) {
        String[] hostAndPort = StringUtils.delimitedListToStringArray((String)source.trim(), (String)":");
        if (!StringUtils.hasText((String)source) || hostAndPort.length > 2) {
            LOG.warn("Could not parse address source '{}'. Check your replica set configuration!", (Object)source);
            return null;
        }
        try {
            return hostAndPort.length == 1 ? new ServerAddress(hostAndPort[0]) : new ServerAddress(hostAndPort[0], Integer.parseInt(hostAndPort[1]));
        }
        catch (UnknownHostException e) {
            LOG.warn("Could not parse host '{}'. Check your replica set configuration!", (Object)hostAndPort[0]);
        }
        catch (NumberFormatException e) {
            LOG.warn("Could not parse port '{}'. Check your replica set configuration!", (Object)hostAndPort[1]);
        }
        return null;
    }
}

