/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.repository.aot;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.jspecify.annotations.Nullable;
import org.springframework.data.jpa.repository.aot.AotQuery;
import org.springframework.data.jpa.repository.aot.NamedAotQuery;
import org.springframework.data.jpa.repository.aot.StringAotQuery;
import org.springframework.data.jpa.repository.query.DeclaredQuery;
import org.springframework.data.jpa.repository.query.QueryEnhancer;
import org.springframework.data.jpa.repository.query.QueryEnhancerSelector;
import org.springframework.data.repository.aot.generate.QueryMetadata;
import org.springframework.util.StringUtils;

record AotQueries(AotQuery result, AotQuery count) {
    public AotQueries(AotQuery query) {
        this(query, AbsentCountQuery.INSTANCE);
    }

    public static <T extends AotQuery> AotQueries withDerivedCountQuery(T query, Function<T, DeclaredQuery> queryMapper, @Nullable String countProjection, QueryEnhancerSelector selector) {
        DeclaredQuery underlyingQuery = queryMapper.apply(query);
        QueryEnhancer queryEnhancer = selector.select(underlyingQuery).create(underlyingQuery);
        if (!queryEnhancer.isSelectQuery()) {
            return new AotQueries(query);
        }
        String derivedCountQuery = queryEnhancer.createCountQueryFor(StringUtils.hasText((String)countProjection) ? countProjection : null);
        return new AotQueries(query, StringAotQuery.of(underlyingQuery.rewrite(derivedCountQuery)));
    }

    public static AotQueries from(AotQuery result, AotQuery count) {
        return new AotQueries(result, count);
    }

    public boolean isNative() {
        return this.result().isNative();
    }

    public QueryMetadata toMetadata(boolean paging) {
        return new AotQueryMetadata(paging);
    }

    private static class AbsentCountQuery
    extends AotQuery {
        static final AbsentCountQuery INSTANCE = new AbsentCountQuery();

        AbsentCountQuery() {
            super(List.of());
        }

        @Override
        public boolean isNative() {
            return false;
        }

        @Override
        public boolean hasConstructorExpressionOrDefaultProjection() {
            return false;
        }
    }

    private class AotQueryMetadata
    implements QueryMetadata {
        private final boolean paging;

        AotQueryMetadata(boolean paging) {
            this.paging = paging;
        }

        public Map<String, Object> serialize() {
            AotQuery aotQuery;
            AotQuery aotQuery2;
            LinkedHashMap<String, Object> serialized = new LinkedHashMap<String, Object>();
            AotQuery aotQuery3 = AotQueries.this.result();
            if (aotQuery3 instanceof NamedAotQuery) {
                NamedAotQuery nq = (NamedAotQuery)aotQuery3;
                serialized.put("name", nq.getName());
                serialized.put("query", nq.getQueryString());
            }
            if ((aotQuery2 = AotQueries.this.result()) instanceof StringAotQuery) {
                StringAotQuery sq = (StringAotQuery)aotQuery2;
                serialized.put("query", sq.getQueryString());
            }
            if ((aotQuery = AotQueries.this.result()) instanceof StringAotQuery.NamedStringAotQuery) {
                StringAotQuery.NamedStringAotQuery nsq = (StringAotQuery.NamedStringAotQuery)aotQuery;
                serialized.put("name", nsq.getQueryName());
            }
            if (this.paging) {
                AotQuery aotQuery4;
                AotQuery aotQuery5;
                AotQuery aotQuery6 = AotQueries.this.count();
                if (aotQuery6 instanceof NamedAotQuery) {
                    NamedAotQuery nq = (NamedAotQuery)aotQuery6;
                    serialized.put("count-name", nq.getName());
                    serialized.put("count-query", nq.getQueryString());
                }
                if ((aotQuery5 = AotQueries.this.count()) instanceof StringAotQuery) {
                    StringAotQuery sq = (StringAotQuery)aotQuery5;
                    serialized.put("count-query", sq.getQueryString());
                }
                if ((aotQuery4 = AotQueries.this.count()) instanceof StringAotQuery.NamedStringAotQuery) {
                    StringAotQuery.NamedStringAotQuery nsq = (StringAotQuery.NamedStringAotQuery)aotQuery4;
                    serialized.put("count-name", nsq.getQueryName());
                }
            }
            return serialized;
        }
    }
}

