/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.repository.query;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.jspecify.annotations.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class Meta {
    private Map<String, Object> values = new LinkedHashMap<String, Object>(2);

    public Meta() {
    }

    Meta(Meta source) {
        this.values = new LinkedHashMap<String, Object>(source.values);
    }

    public void setComment(String comment) {
        this.setValue(MetaKey.COMMENT.key, comment);
    }

    @Nullable
    public String getComment() {
        return (String)this.getValue(MetaKey.COMMENT.key);
    }

    public boolean hasValues() {
        return !this.values.isEmpty();
    }

    public Iterable<Map.Entry<String, Object>> values() {
        return Collections.unmodifiableSet(this.values.entrySet());
    }

    void setValue(String key, @Nullable Object value) {
        String stringValue;
        Assert.hasText((String)key, (String)"Meta key must not be 'null' or blank");
        if (value == null || value instanceof String && !StringUtils.hasText((String)(stringValue = (String)value))) {
            this.values.remove(key);
        }
        this.values.put(key, value);
    }

    private <T> @Nullable T getValue(String key) {
        return (T)this.values.get(key);
    }

    private static enum MetaKey {
        COMMENT("comment");

        private String key;

        private MetaKey(String key) {
            this.key = key;
        }
    }
}

