/*
 * Copyright 2013-2025 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.springframework.data.jpa.provider;

import jakarta.persistence.Query;

import org.springframework.lang.Nullable;

/**
 * Interface to hide different implementations of query hints that insert comments into a {@link Query}.
 *
 * @author Greg Turnquist
 * @since 3.0
 */
public interface QueryComment {

	@Nullable
	String getCommentHintKey();

	@Nullable
	default String getCommentHintValue(String comment) {
		return comment;
	}
}
