/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.util;

import jakarta.persistence.Embeddable;
import jakarta.persistence.metamodel.EntityType;
import jakarta.persistence.metamodel.ManagedType;
import jakarta.persistence.metamodel.Metamodel;
import jakarta.persistence.metamodel.SingularAttribute;
import jakarta.persistence.metamodel.Type;
import java.lang.reflect.AnnotatedElement;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.data.util.Lazy;
import org.springframework.data.util.StreamUtils;
import org.springframework.util.Assert;

public class JpaMetamodel {
    private static final Map<Metamodel, JpaMetamodel> CACHE = new ConcurrentHashMap<Metamodel, JpaMetamodel>(4);
    private final Metamodel metamodel;
    private Lazy<Collection<Class<?>>> managedTypes;
    private Lazy<Collection<Class<?>>> jpaEmbeddables;

    private JpaMetamodel(Metamodel metamodel) {
        Assert.notNull((Object)metamodel, (String)"Metamodel must not be null");
        this.metamodel = metamodel;
        this.managedTypes = Lazy.of(() -> (Collection)metamodel.getManagedTypes().stream().map(Type::getJavaType).filter(it -> it != null).collect(StreamUtils.toUnmodifiableSet()));
        this.jpaEmbeddables = Lazy.of(() -> (Collection)metamodel.getEmbeddables().stream().map(Type::getJavaType).filter(it -> it != null).filter(it -> AnnotatedElementUtils.isAnnotated((AnnotatedElement)it, Embeddable.class)).collect(StreamUtils.toUnmodifiableSet()));
    }

    public static JpaMetamodel of(Metamodel metamodel) {
        return CACHE.computeIfAbsent(metamodel, JpaMetamodel::new);
    }

    public boolean isJpaManaged(Class<?> type) {
        Assert.notNull(type, (String)"Type must not be null");
        return ((Collection)this.managedTypes.get()).contains(type);
    }

    public boolean isSingleIdAttribute(Class<?> entity, String name, Class<?> attributeType) {
        return this.metamodel.getEntities().stream().filter(it -> entity.equals(it.getJavaType())).findFirst().flatMap(it -> JpaMetamodel.getSingularIdAttribute(it)).filter(it -> it.getJavaType().equals(attributeType)).map(it -> it.getName().equals(name)).orElse(false);
    }

    public boolean isMappedType(Class<?> entity) {
        Assert.notNull(entity, (String)"Type must not be null");
        if (!this.isJpaManaged(entity)) {
            return false;
        }
        ManagedType managedType = this.metamodel.managedType(entity);
        return !managedType.getPersistenceType().equals((Object)Type.PersistenceType.EMBEDDABLE) || ((Collection)this.jpaEmbeddables.get()).contains(entity);
    }

    static void clear() {
        CACHE.clear();
    }

    private static Optional<? extends SingularAttribute<?, ?>> getSingularIdAttribute(EntityType<?> entityType) {
        if (!entityType.hasSingleIdAttribute()) {
            return Optional.empty();
        }
        return entityType.getSingularAttributes().stream().filter(SingularAttribute::isId).findFirst();
    }
}

