/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.repository.query;

import java.util.Iterator;
import javax.persistence.EntityManager;
import javax.persistence.ParameterMode;
import javax.persistence.StoredProcedureQuery;
import javax.persistence.TypedQuery;
import org.springframework.data.jpa.repository.query.AbstractJpaQuery;
import org.springframework.data.jpa.repository.query.JpaParameters;
import org.springframework.data.jpa.repository.query.JpaQueryMethod;
import org.springframework.data.jpa.repository.query.StoredProcedureAttributes;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

class StoredProcedureJpaQuery
extends AbstractJpaQuery {
    private final StoredProcedureAttributes procedureAttributes;

    public StoredProcedureJpaQuery(JpaQueryMethod method, EntityManager em) {
        super(method, em);
        this.procedureAttributes = method.getProcedureAttributes();
    }

    protected StoredProcedureQuery createQuery(Object[] values) {
        return this.applyHints(this.doCreateQuery(values), this.getQueryMethod());
    }

    protected StoredProcedureQuery doCreateQuery(Object[] values) {
        StoredProcedureQuery proc = this.createStoredProcedure();
        return this.createBinder(values).bind(proc);
    }

    @Override
    protected TypedQuery<Long> doCreateCountQuery(Object[] values) {
        return null;
    }

    Object extractOutputValue(StoredProcedureQuery storedProcedureQuery) {
        Assert.notNull((Object)storedProcedureQuery, (String)"StoredProcedureQuery must not be null!");
        if (!this.procedureAttributes.hasReturnValue()) {
            return null;
        }
        if (StringUtils.hasText((String)this.procedureAttributes.getOutputParameterName())) {
            return storedProcedureQuery.getOutputParameterValue(this.procedureAttributes.getOutputParameterName());
        }
        return storedProcedureQuery.getOutputParameterValue(this.getQueryMethod().getParameters().getNumberOfParameters() + 1);
    }

    private StoredProcedureQuery createStoredProcedure() {
        return this.procedureAttributes.isNamedStoredProcedure() ? this.newNamedStoredProcedureQuery() : this.newAdhocStoredProcedureQuery();
    }

    private StoredProcedureQuery newNamedStoredProcedureQuery() {
        return this.getEntityManager().createNamedStoredProcedureQuery(this.procedureAttributes.getProcedureName());
    }

    private StoredProcedureQuery newAdhocStoredProcedureQuery() {
        StoredProcedureQuery procedureQuery = this.getEntityManager().createStoredProcedureQuery(this.procedureAttributes.getProcedureName());
        JpaParameters params = this.getQueryMethod().getParameters();
        Iterator i$ = params.iterator();
        while (i$.hasNext()) {
            JpaParameters.JpaParameter param = (JpaParameters.JpaParameter)((Object)i$.next());
            if (!param.isBindable()) continue;
            if (param.isNamedParameter()) {
                procedureQuery.registerStoredProcedureParameter(param.getName(), param.getType(), ParameterMode.IN);
                continue;
            }
            procedureQuery.registerStoredProcedureParameter(param.getIndex() + 1, param.getType(), ParameterMode.IN);
        }
        if (this.procedureAttributes.hasReturnValue()) {
            procedureQuery.registerStoredProcedureParameter(params.getNumberOfParameters() + 1, this.procedureAttributes.getOutputParameterType(), ParameterMode.OUT);
        }
        return procedureQuery;
    }
}

