/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.repository.support;

import java.io.Serializable;
import javax.persistence.EntityManager;
import javax.persistence.metamodel.Metamodel;
import org.springframework.data.domain.Persistable;
import org.springframework.data.jpa.repository.query.DefaultJpaEntityMetadata;
import org.springframework.data.jpa.repository.query.JpaEntityMetadata;
import org.springframework.data.jpa.repository.support.JpaEntityInformation;
import org.springframework.data.jpa.repository.support.JpaMetamodelEntityInformation;
import org.springframework.data.jpa.repository.support.JpaPersistableEntityInformation;
import org.springframework.data.repository.core.support.AbstractEntityInformation;
import org.springframework.util.Assert;

public abstract class JpaEntityInformationSupport<T, ID extends Serializable>
extends AbstractEntityInformation<T, ID>
implements JpaEntityInformation<T, ID> {
    private JpaEntityMetadata<T> metadata;

    public JpaEntityInformationSupport(Class<T> domainClass) {
        super(domainClass);
        this.metadata = new DefaultJpaEntityMetadata<T>(domainClass);
    }

    public static <T> JpaEntityInformation<T, ?> getEntityInformation(Class<T> domainClass, EntityManager em) {
        Assert.notNull(domainClass);
        Assert.notNull((Object)em);
        Metamodel metamodel = em.getMetamodel();
        if (Persistable.class.isAssignableFrom(domainClass)) {
            return new JpaPersistableEntityInformation(domainClass, metamodel);
        }
        return new JpaMetamodelEntityInformation(domainClass, metamodel);
    }

    @Override
    public String getEntityName() {
        return this.metadata.getEntityName();
    }
}

