/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.repository.support;

import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.AutowireCandidateQualifier;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionReaderUtils;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.data.jpa.util.BeanDefinitionUtils;

public class EntityManagerBeanDefinitionRegistrarPostProcessor
implements BeanFactoryPostProcessor {
    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        for (BeanDefinitionUtils.EntityManagerFactoryBeanDefinition definition : BeanDefinitionUtils.getEntityManagerFactoryBeanDefinitions(beanFactory)) {
            if (!(definition.getBeanFactory() instanceof BeanDefinitionRegistry)) continue;
            BeanDefinitionBuilder builder = BeanDefinitionBuilder.rootBeanDefinition((String)"org.springframework.orm.jpa.SharedEntityManagerCreator");
            builder.setFactoryMethod("createSharedEntityManager");
            builder.addConstructorArgReference(definition.getBeanName());
            AbstractBeanDefinition emBeanDefinition = builder.getRawBeanDefinition();
            emBeanDefinition.addQualifier(new AutowireCandidateQualifier(Qualifier.class, (Object)definition.getBeanName()));
            emBeanDefinition.setScope(definition.getBeanDefinition().getScope());
            emBeanDefinition.setSource(definition.getBeanDefinition().getSource());
            BeanDefinitionReaderUtils.registerWithGeneratedName((AbstractBeanDefinition)emBeanDefinition, (BeanDefinitionRegistry)((BeanDefinitionRegistry)definition.getBeanFactory()));
        }
    }
}

