/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jdbc.core.convert;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.jspecify.annotations.Nullable;
import org.springframework.data.jdbc.core.convert.PathToColumnMapping;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.relational.core.mapping.AggregatePath;
import org.springframework.data.relational.core.mapping.RelationalMappingContext;
import org.springframework.data.relational.core.mapping.RelationalPersistentEntity;
import org.springframework.data.relational.core.mapping.RelationalPersistentProperty;
import org.springframework.data.relational.core.mapping.RelationalPredicates;
import org.springframework.data.relational.core.sql.SqlIdentifier;
import org.springframework.data.relational.domain.RowDocument;
import org.springframework.util.Assert;

abstract class RowDocumentExtractorSupport {
    RowDocumentExtractorSupport() {
    }

    private static class MapContainer
    extends CollectionContainer {
        private final Map<Object, @Nullable Object> map = new LinkedHashMap<Object, Object>();

        private MapContainer() {
        }

        @Override
        public void add(Object key, @Nullable Object value) {
            this.map.put(key, value);
        }

        @Override
        public Map<Object, @Nullable Object> get() {
            return new LinkedHashMap<Object, Object>(this.map);
        }
    }

    private static class ListContainer
    extends CollectionContainer {
        private final Map<Number, Object> list = new TreeMap<Number, Object>(Comparator.comparing(Number::longValue));

        private ListContainer() {
        }

        @Override
        public void add(Object key, @Nullable Object value) {
            this.list.put(((Number)key).intValue() - 1, value);
        }

        @Override
        public List<@Nullable Object> get() {
            ArrayList<@Nullable Object> result = new ArrayList<Object>(this.list.size());
            this.list.forEach((index, o) -> {
                while (result.size() < index.intValue()) {
                    result.add(null);
                }
                result.add(o);
            });
            return result;
        }
    }

    private static abstract class CollectionContainer {
        private CollectionContainer() {
        }

        abstract void add(Object var1, @Nullable Object var2);

        abstract Object get();
    }

    private static class ContainerSink<RS>
    extends TabularSink<RS> {
        private final String keyColumn;
        private final AggregateContext<RS> aggregateContext;
        private @Nullable Object key;
        private boolean hasResult = false;
        private final TabularSink<RS> componentReader;
        private final CollectionContainer container;

        public ContainerSink(AggregateContext<RS> aggregateContext, RelationalPersistentProperty property, AggregatePath path) {
            this.aggregateContext = aggregateContext;
            this.keyColumn = aggregateContext.getKeyColumnName(path);
            this.componentReader = property.isEntity() ? new RowDocumentSink<RS>(aggregateContext, aggregateContext.getRequiredPersistentEntity(property), path) : new SingleColumnSink<RS>(aggregateContext, path);
            this.container = property.isMap() ? new MapContainer() : new ListContainer();
        }

        @Override
        void accept(RS row) {
            boolean keyChange;
            if (!this.aggregateContext.containsColumn(this.keyColumn)) {
                return;
            }
            Object key = this.aggregateContext.getObject(row, this.keyColumn);
            if (key == null && !this.hasResult) {
                return;
            }
            boolean bl = keyChange = key != null && !key.equals(this.key);
            if (!this.hasResult) {
                this.hasResult = true;
            }
            if (keyChange && this.componentReader.hasResult()) {
                Assert.state((this.key != null ? 1 : 0) != 0, (String)"Key must not be null");
                this.container.add(this.key, this.componentReader.getResult());
                this.componentReader.reset();
            }
            if (key != null) {
                this.key = key;
            }
            this.componentReader.accept(row);
        }

        @Override
        public boolean hasResult() {
            return this.hasResult;
        }

        @Override
        public Object getResult() {
            if (this.componentReader.hasResult()) {
                Assert.state((this.key != null ? 1 : 0) != 0, (String)"Key must not be null");
                this.container.add(this.key, this.componentReader.getResult());
                this.componentReader.reset();
            }
            return this.container.get();
        }

        @Override
        void reset() {
            this.hasResult = false;
        }
    }

    private static class SingleColumnSink<RS>
    extends TabularSink<RS> {
        private final AggregateContext<RS> aggregateContext;
        private final String columnName;
        private @Nullable Object value;

        public SingleColumnSink(AggregateContext<RS> aggregateContext, AggregatePath path) {
            this.aggregateContext = aggregateContext;
            this.columnName = path.getColumnInfo().name().getReference();
        }

        @Override
        void accept(RS row) {
            this.value = this.aggregateContext.containsColumn(this.columnName) ? this.aggregateContext.getObject(row, this.columnName) : null;
        }

        @Override
        boolean hasResult() {
            return this.value != null;
        }

        @Override
        Object getResult() {
            Object result = this.getValue();
            Assert.state((result != null ? 1 : 0) != 0, (String)"Result must not be null");
            return result;
        }

        public @Nullable Object getValue() {
            return this.value;
        }

        @Override
        void reset() {
            this.value = null;
        }
    }

    protected static class RowDocumentSink<RS>
    extends TabularSink<RS> {
        private final AggregateContext<RS> aggregateContext;
        private final RelationalPersistentEntity<?> entity;
        private final AggregatePath basePath;
        private @Nullable RowDocument result;
        private final String keyColumnName;
        private @Nullable Object key;
        private final Map<RelationalPersistentProperty, TabularSink<RS>> readerState = new LinkedHashMap<RelationalPersistentProperty, TabularSink<RS>>();

        public RowDocumentSink(AggregateContext<RS> aggregateContext, RelationalPersistentEntity<?> entity, AggregatePath basePath) {
            this.aggregateContext = aggregateContext;
            this.entity = entity;
            this.basePath = basePath;
            String keyColumnName = entity.hasIdProperty() ? aggregateContext.getColumnName(basePath.append((RelationalPersistentProperty)entity.getRequiredIdProperty())) : aggregateContext.getColumnName(basePath);
            this.keyColumnName = keyColumnName;
        }

        @Override
        void accept(RS row) {
            boolean first;
            boolean bl = first = this.result == null;
            if (first) {
                RowDocument document = new RowDocument();
                this.readFirstRow(row, document);
                this.result = document;
            }
            for (TabularSink<RS> reader : this.readerState.values()) {
                reader.accept(row);
            }
        }

        private void readFirstRow(RS row, RowDocument document) {
            if (this.aggregateContext.containsColumn(this.keyColumnName)) {
                this.key = this.aggregateContext.getObject(row, this.keyColumnName);
            }
            this.readEntity(row, document, this.basePath, this.entity);
        }

        private void readEntity(RS row, RowDocument document, AggregatePath basePath, RelationalPersistentEntity<?> entity) {
            for (RelationalPersistentProperty property : entity) {
                AggregatePath path = basePath.append(property);
                if (RelationalPredicates.isRelation((RelationalPersistentProperty)property) && (property.isCollectionLike() || property.isQualified())) {
                    this.readerState.put(property, new ContainerSink<RS>(this.aggregateContext, property, path));
                    continue;
                }
                if (property.isEmbedded()) {
                    RelationalPersistentEntity<?> embeddedEntity = this.aggregateContext.getRequiredPersistentEntity(property);
                    this.readEntity(row, document, path, embeddedEntity);
                    continue;
                }
                if (property.isEntity()) {
                    this.readerState.put(property, new RowDocumentSink<RS>(this.aggregateContext, this.aggregateContext.getRequiredPersistentEntity(property), path));
                    continue;
                }
                this.aggregateContext.collectValue(row, path, document, property.getColumnName());
            }
        }

        private void collectEmbeddedValues(RS row, RowDocument document, RelationalPersistentProperty property, AggregatePath path) {
            RelationalPersistentEntity<?> embeddedHolder = this.aggregateContext.getRequiredPersistentEntity(property);
            for (RelationalPersistentProperty embeddedProperty : embeddedHolder) {
                if (embeddedProperty.isQualified() || embeddedProperty.isCollectionLike() || embeddedProperty.isEntity()) {
                    throw new UnsupportedOperationException("Reading maps and collections into embeddable isn't supported yet");
                }
                AggregatePath nested = path.append(embeddedProperty);
                this.aggregateContext.collectValue(row, nested, document, nested.getColumnInfo().name());
            }
        }

        @Override
        boolean hasResult() {
            if (this.result == null) {
                return false;
            }
            for (TabularSink<RS> value : this.readerState.values()) {
                if (!value.hasResult()) continue;
                return true;
            }
            return !this.result.isEmpty() || this.key != null;
        }

        RowDocument getResult() {
            Assert.state((this.result != null ? 1 : 0) != 0, (String)"Result must not be null");
            this.readerState.forEach((property, reader) -> {
                if (reader.hasResult()) {
                    this.result.put(property.getColumnName().getReference(), reader.getResult());
                }
            });
            return this.result;
        }

        @Override
        void reset() {
            this.result = null;
            this.readerState.clear();
        }
    }

    protected static abstract class TabularSink<RS> {
        protected TabularSink() {
        }

        abstract void accept(RS var1);

        abstract boolean hasResult();

        abstract @Nullable Object getResult();

        abstract void reset();
    }

    protected static class AggregateContext<RS> {
        private final TabularResultAdapter<RS> adapter;
        private final RelationalMappingContext context;
        private final PathToColumnMapping propertyToColumn;
        private final Map<String, Integer> columnMap;

        protected AggregateContext(TabularResultAdapter<RS> adapter, RelationalMappingContext context, PathToColumnMapping propertyToColumn, Map<String, Integer> columnMap) {
            this.adapter = adapter;
            this.context = context;
            this.propertyToColumn = propertyToColumn;
            this.columnMap = columnMap;
        }

        public RelationalPersistentEntity<?> getRequiredPersistentEntity(RelationalPersistentProperty property) {
            return (RelationalPersistentEntity)this.context.getRequiredPersistentEntity((PersistentProperty)property);
        }

        public String getColumnName(AggregatePath path) {
            return this.propertyToColumn.column(path);
        }

        public String getKeyColumnName(AggregatePath path) {
            return this.propertyToColumn.keyColumn(path);
        }

        public boolean containsColumn(String columnName) {
            return this.columnMap.containsKey(columnName);
        }

        public @Nullable Object getObject(RS row, String columnName) {
            Integer index = this.columnMap.get(columnName);
            Assert.state((index != null ? 1 : 0) != 0, () -> "Column '%s' not found".formatted(columnName));
            return this.adapter.getObject(row, index);
        }

        void collectValue(RS row, AggregatePath source, RowDocument document, SqlIdentifier targetName) {
            String columnLabel = this.propertyToColumn.column(source);
            Integer index = this.columnMap.get(columnLabel);
            if (index == null) {
                return;
            }
            Object resultSetValue = this.adapter.getObject(row, index);
            if (resultSetValue == null) {
                return;
            }
            document.put(targetName.getReference(), resultSetValue);
        }
    }

    static interface TabularResultAdapter<RS> {
        public @Nullable Object getObject(RS var1, int var2);

        public Map<String, Integer> getColumnMap(RS var1);
    }
}

