/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jdbc.core.convert;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.springframework.data.jdbc.core.convert.BindParameterNameSanitizer;
import org.springframework.data.relational.core.sql.SqlIdentifier;
import org.springframework.jdbc.core.namedparam.AbstractSqlParameterSource;

class SqlIdentifierParameterSource
extends AbstractSqlParameterSource {
    private final Set<SqlIdentifier> identifiers = new HashSet<SqlIdentifier>(16, 1.0f);
    private final Map<String, Object> namesToValues = new HashMap<String, Object>(16, 1.0f);

    SqlIdentifierParameterSource() {
    }

    public boolean hasValue(String paramName) {
        return this.namesToValues.containsKey(paramName);
    }

    public Object getValue(String paramName) throws IllegalArgumentException {
        return this.namesToValues.get(paramName);
    }

    public String[] getParameterNames() {
        return this.namesToValues.keySet().toArray(new String[0]);
    }

    Set<SqlIdentifier> getIdentifiers() {
        return Collections.unmodifiableSet(this.identifiers);
    }

    void addValue(SqlIdentifier name, Object value) {
        this.addValue(name, value, Integer.MIN_VALUE);
    }

    void addValue(SqlIdentifier identifier, Object value, int sqlType) {
        this.identifiers.add(identifier);
        String name = BindParameterNameSanitizer.sanitize(identifier.getReference());
        this.namesToValues.put(name, value);
        this.registerSqlType(name, sqlType);
    }

    void addAll(SqlIdentifierParameterSource others) {
        for (SqlIdentifier identifier : others.getIdentifiers()) {
            String name = BindParameterNameSanitizer.sanitize(identifier.getReference());
            this.addValue(identifier, others.getValue(name), others.getSqlType(name));
        }
    }

    int size() {
        return this.namesToValues.size();
    }
}

