/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jdbc.core.mapping.schema;

import org.springframework.data.relational.core.mapping.RelationalPersistentProperty;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

@FunctionalInterface
public interface SqlTypeMapping {
    @Nullable
    public String getColumnType(RelationalPersistentProperty var1);

    @Nullable
    default public String getColumnType(Class<?> type) {
        return null;
    }

    default public String getRequiredColumnType(RelationalPersistentProperty property) {
        String columnType = this.getColumnType(property);
        if (ObjectUtils.isEmpty((Object)columnType)) {
            throw new IllegalArgumentException(String.format("Cannot determined required column type for %s", property));
        }
        return columnType;
    }

    default public boolean isNullable(RelationalPersistentProperty property) {
        return !property.getActualType().isPrimitive();
    }

    default public SqlTypeMapping and(SqlTypeMapping other) {
        Assert.notNull((Object)other, (String)"Other SqlTypeMapping must not be null");
        return property -> {
            String columnType = this.getColumnType(property);
            if (ObjectUtils.isEmpty((Object)columnType)) {
                return other.getColumnType(property);
            }
            return columnType;
        };
    }
}

