/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jdbc.core.dialect;

import java.sql.Timestamp;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Collection;
import org.springframework.core.convert.converter.Converter;
import org.springframework.data.convert.WritingConverter;
import org.springframework.data.jdbc.core.convert.Jsr310TimestampBasedConverters;
import org.springframework.data.relational.core.dialect.Db2Dialect;

public class JdbcDb2Dialect
extends Db2Dialect {
    public static JdbcDb2Dialect INSTANCE = new JdbcDb2Dialect();

    protected JdbcDb2Dialect() {
    }

    public Collection<Object> getConverters() {
        ArrayList<Object> converters = new ArrayList<Object>(super.getConverters());
        converters.add((Object)OffsetDateTimeToTimestampConverter.INSTANCE);
        converters.add((Object)Jsr310TimestampBasedConverters.LocalDateTimeToTimestampConverter.INSTANCE);
        return converters;
    }

    @WritingConverter
    static enum OffsetDateTimeToTimestampConverter implements Converter<OffsetDateTime, Timestamp>
    {
        INSTANCE;


        public Timestamp convert(OffsetDateTime source) {
            return Timestamp.from(source.toInstant());
        }
    }
}

