/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jdbc.core.convert;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import org.springframework.data.jdbc.core.convert.ResultSetAccessor;
import org.springframework.lang.Nullable;

class CachingResultSet {
    private final ResultSetAccessor accessor;
    private final ResultSet resultSet;
    private Cache cache;

    CachingResultSet(ResultSet resultSet) {
        this.accessor = new ResultSetAccessor(resultSet);
        this.resultSet = resultSet;
    }

    public boolean next() {
        if (this.isPeeking()) {
            boolean next = this.cache.next;
            this.cache = null;
            return next;
        }
        try {
            return this.resultSet.next();
        }
        catch (SQLException e) {
            throw new RuntimeException("Failed to advance CachingResultSet", e);
        }
    }

    @Nullable
    public Object getObject(String columnLabel) {
        Object returnValue = this.isPeeking() ? this.cache.values.get(columnLabel) : this.safeGetFromDelegate(columnLabel);
        return returnValue;
    }

    @Nullable
    Object peek(String columnLabel) {
        if (!this.isPeeking()) {
            this.createCache();
        }
        if (!this.cache.next) {
            return null;
        }
        return this.safeGetFromDelegate(columnLabel);
    }

    @Nullable
    private Object safeGetFromDelegate(String columnLabel) {
        return this.accessor.getObject(columnLabel);
    }

    private void createCache() {
        this.cache = new Cache();
        try {
            int columnCount = this.resultSet.getMetaData().getColumnCount();
            for (int i = 1; i <= columnCount; ++i) {
                this.cache.add(this.resultSet.getMetaData().getColumnLabel(i).toLowerCase(), this.accessor.getObject(this.resultSet.getMetaData().getColumnLabel(i)));
            }
            this.cache.next = this.resultSet.next();
        }
        catch (SQLException se) {
            throw new RuntimeException("Can't cache result set data", se);
        }
    }

    private boolean isPeeking() {
        return this.cache != null;
    }

    private static class Cache {
        boolean next;
        Map<String, Object> values = new HashMap<String, Object>();

        private Cache() {
        }

        void add(String columnName, Object value) {
            this.values.put(columnName, value);
        }
    }
}

