/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.hadoop.boot;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.hadoop.boot.properties.SpringHadoopEnvProperties;
import org.springframework.data.hadoop.boot.properties.SpringHadoopProperties;
import org.springframework.data.hadoop.config.annotation.EnableHadoop;
import org.springframework.data.hadoop.config.annotation.SpringHadoopConfigurerAdapter;
import org.springframework.data.hadoop.config.annotation.builders.HadoopConfigConfigurer;

@Configuration
@ConditionalOnClass(value={EnableHadoop.class})
@ConditionalOnMissingBean(value={org.apache.hadoop.conf.Configuration.class})
public class HadoopAutoConfiguration {

    @Configuration
    @EnableConfigurationProperties(value={SpringHadoopProperties.class, SpringHadoopEnvProperties.class})
    @EnableHadoop
    public static class SpringHadoopConfig
    extends SpringHadoopConfigurerAdapter {
        @Autowired
        private SpringHadoopProperties shp;

        public void configure(HadoopConfigConfigurer config) throws Exception {
            ((HadoopConfigConfigurer)((HadoopConfigConfigurer)config.fileSystemUri(this.shp.getFsUri()).resourceManagerAddress(this.shp.getResourceManagerAddress()).withProperties().properties(this.shp.getConfig()).and()).withResources().resources(this.shp.getResources()).and()).withSecurity().namenodePrincipal(this.shp.getSecurity() != null ? this.shp.getSecurity().getNamenodePrincipal() : null).rmManagerPrincipal(this.shp.getSecurity() != null ? this.shp.getSecurity().getRmManagerPrincipal() : null).authMethod(this.shp.getSecurity() != null ? this.shp.getSecurity().getAuthMethod() : null).userPrincipal(this.shp.getSecurity() != null ? this.shp.getSecurity().getUserPrincipal() : null).userKeytab(this.shp.getSecurity() != null ? this.shp.getSecurity().getUserKeytab() : null);
        }
    }
}

