/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.function.config;

import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.annotation.Inherited;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.springframework.beans.factory.annotation.AnnotatedBeanDefinition;
import org.springframework.context.annotation.ClassPathScanningCandidateComponentProvider;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.core.type.classreading.MetadataReader;
import org.springframework.core.type.classreading.MetadataReaderFactory;
import org.springframework.core.type.filter.AbstractTypeHierarchyTraversingFilter;
import org.springframework.core.type.filter.TypeFilter;
import org.springframework.data.gemfire.util.CollectionUtils;
import org.springframework.util.Assert;

class FunctionExecutionComponentProvider
extends ClassPathScanningCandidateComponentProvider {
    private final Set<Class<? extends Annotation>> functionExecutionAnnotationTypes;

    public FunctionExecutionComponentProvider(Iterable<? extends TypeFilter> includeFilters, Set<Class<? extends Annotation>> functionExecutionAnnotationTypes) {
        super(false);
        this.functionExecutionAnnotationTypes = functionExecutionAnnotationTypes;
        if (!CollectionUtils.nullSafeIsEmpty(includeFilters)) {
            for (TypeFilter typeFilter : includeFilters) {
                this.addIncludeFilter(typeFilter);
            }
        } else {
            for (Class<? extends Annotation> clazz : this.functionExecutionAnnotationTypes) {
                super.addIncludeFilter((TypeFilter)new AnnotationTypeFilter(clazz, true, true));
            }
        }
    }

    public void addIncludeFilter(TypeFilter includeFilter) {
        ArrayList<TypeFilter> filterPlusInterface = new ArrayList<TypeFilter>();
        filterPlusInterface.add(includeFilter);
        super.addIncludeFilter((TypeFilter)new AllTypeFilter(filterPlusInterface));
        ArrayList<TypeFilter> filterPlusAnnotation = new ArrayList<TypeFilter>();
        filterPlusAnnotation.add(includeFilter);
        for (Class<? extends Annotation> annotation : this.functionExecutionAnnotationTypes) {
            filterPlusAnnotation.add((TypeFilter)new AnnotationTypeFilter(annotation, true, true));
        }
        super.addIncludeFilter((TypeFilter)new AllTypeFilter(filterPlusAnnotation));
    }

    protected boolean isCandidateComponent(AnnotatedBeanDefinition beanDefinition) {
        boolean isTopLevelType = !beanDefinition.getMetadata().hasEnclosingClass();
        return isTopLevelType;
    }

    private static class AllTypeFilter
    implements TypeFilter {
        private final List<TypeFilter> delegates;

        public AllTypeFilter(List<TypeFilter> delegates) {
            Assert.notNull(delegates, (String)"Delegate TypeFilters must not be null");
            this.delegates = delegates;
        }

        public boolean match(MetadataReader metadataReader, MetadataReaderFactory metadataReaderFactory) throws IOException {
            for (TypeFilter filter : this.delegates) {
                if (filter.match(metadataReader, metadataReaderFactory)) continue;
                return false;
            }
            return true;
        }
    }

    private static class AnnotationTypeFilter
    extends AbstractTypeHierarchyTraversingFilter {
        private final Class<? extends Annotation> annotationType;
        private final boolean considerMetaAnnotations;

        public AnnotationTypeFilter(Class<? extends Annotation> annotationType) {
            this(annotationType, true);
        }

        public AnnotationTypeFilter(Class<? extends Annotation> annotationType, boolean considerMetaAnnotations) {
            this(annotationType, considerMetaAnnotations, false);
        }

        public AnnotationTypeFilter(Class<? extends Annotation> annotationType, boolean considerMetaAnnotations, boolean considerInterfaces) {
            super(annotationType.isAnnotationPresent(Inherited.class), considerInterfaces);
            this.annotationType = annotationType;
            this.considerMetaAnnotations = considerMetaAnnotations;
        }

        protected boolean matchSelf(MetadataReader metadataReader) {
            AnnotationMetadata metadata = metadataReader.getAnnotationMetadata();
            return metadata.hasAnnotation(this.annotationType.getName()) || this.considerMetaAnnotations && metadata.hasMetaAnnotation(this.annotationType.getName());
        }

        protected Boolean matchSuperClass(String superClassName) {
            if (Object.class.getName().equals(superClassName)) {
                return Boolean.FALSE;
            }
            if (superClassName.startsWith("java.")) {
                try {
                    Class<?> type = ((Object)((Object)this)).getClass().getClassLoader().loadClass(superClassName);
                    return type.getAnnotation(this.annotationType) != null;
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
            }
            return null;
        }
    }
}

