/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.eviction;

import org.apache.geode.cache.EvictionAction;
import org.apache.geode.cache.EvictionAttributes;
import org.apache.geode.cache.util.ObjectSizer;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.data.gemfire.eviction.EvictionPolicyType;

public class EvictionAttributesFactoryBean
implements FactoryBean<EvictionAttributes>,
InitializingBean {
    protected static final int DEFAULT_LRU_MAXIMUM_ENTRIES = 900;
    protected static final int DEFAULT_MEMORY_MAXIMUM_SIZE = 10;
    private EvictionAction action = null;
    private EvictionAttributes evictionAttributes;
    private EvictionPolicyType type = EvictionPolicyType.ENTRY_COUNT;
    private Integer threshold = null;
    private ObjectSizer objectSizer = null;

    public void afterPropertiesSet() {
        this.evictionAttributes = this.createAttributes();
    }

    EvictionAttributes createAttributes() {
        switch (this.type) {
            case HEAP_PERCENTAGE: {
                if (this.threshold != null) {
                    throw new IllegalArgumentException("HEAP_PERCENTAGE (LRU_HEAP algorithm) does not support threshold (a.k.a. maximum)");
                }
                return EvictionAttributes.createLRUHeapAttributes((ObjectSizer)this.getObjectSizer(), (EvictionAction)this.getAction());
            }
            case MEMORY_SIZE: {
                return this.threshold != null ? EvictionAttributes.createLRUMemoryAttributes((int)this.getThreshold(), (ObjectSizer)this.getObjectSizer(), (EvictionAction)this.getAction()) : EvictionAttributes.createLRUMemoryAttributes((ObjectSizer)this.getObjectSizer(), (EvictionAction)this.getAction());
            }
        }
        return this.threshold != null ? EvictionAttributes.createLRUEntryAttributes((int)this.getThreshold(), (EvictionAction)this.getAction()) : EvictionAttributes.createLRUEntryAttributes((int)900, (EvictionAction)this.getAction());
    }

    public EvictionAttributes getObject() {
        return this.evictionAttributes;
    }

    public Class<?> getObjectType() {
        return this.evictionAttributes != null ? this.evictionAttributes.getClass() : EvictionAttributes.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public void setAction(EvictionAction action) {
        this.action = action;
    }

    public EvictionAction getAction() {
        return this.action != null ? this.action : EvictionAction.DEFAULT_EVICTION_ACTION;
    }

    public void setObjectSizer(ObjectSizer objectSizer) {
        this.objectSizer = objectSizer;
    }

    public ObjectSizer getObjectSizer() {
        return this.objectSizer;
    }

    public void setThreshold(Integer threshold) {
        this.threshold = threshold;
    }

    public Integer getThreshold() {
        return this.threshold;
    }

    public void setType(EvictionPolicyType type) {
        this.type = type;
    }

    public EvictionPolicyType getType() {
        return this.type;
    }
}

