/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.client;

import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.StreamSupport;
import org.apache.geode.cache.GemFireCache;
import org.apache.geode.cache.client.ClientCache;
import org.apache.geode.cache.client.Pool;
import org.apache.geode.cache.client.PoolFactory;
import org.apache.geode.cache.client.PoolManager;
import org.apache.geode.cache.client.SocketFactory;
import org.apache.geode.cache.query.QueryService;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.data.gemfire.GemfireUtils;
import org.springframework.data.gemfire.client.PoolAdapter;
import org.springframework.data.gemfire.client.PoolResolver;
import org.springframework.data.gemfire.client.support.PoolManagerPoolResolver;
import org.springframework.data.gemfire.config.annotation.PoolConfigurer;
import org.springframework.data.gemfire.support.AbstractFactoryBeanSupport;
import org.springframework.data.gemfire.support.ConnectionEndpoint;
import org.springframework.data.gemfire.support.ConnectionEndpointList;
import org.springframework.data.gemfire.util.ArrayUtils;
import org.springframework.data.gemfire.util.CollectionUtils;
import org.springframework.data.gemfire.util.DistributedSystemUtils;
import org.springframework.data.gemfire.util.RuntimeExceptionFactory;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import org.springframework.util.StringUtils;

public class PoolFactoryBean
extends AbstractFactoryBeanSupport<Pool>
implements DisposableBean,
InitializingBean {
    protected static final int DEFAULT_LOCATOR_PORT = 10334;
    protected static final int DEFAULT_SERVER_PORT = 40404;
    protected static final PoolResolver DEFAULT_POOL_RESOLVER = new PoolManagerPoolResolver();
    volatile boolean springManagedPool = true;
    private boolean keepAlive = false;
    private boolean multiUserAuthentication = false;
    private boolean prSingleHopEnabled = true;
    private boolean subscriptionEnabled = false;
    private boolean threadLocalConnections = false;
    private int freeConnectionTimeout = 10000;
    private int loadConditioningInterval = 300000;
    private int maxConnections = -1;
    private int minConnections = 1;
    private int readTimeout = 10000;
    private int retryAttempts = -1;
    private int serverConnectionTimeout = 0;
    private int socketBufferSize = 32768;
    private int socketConnectTimeout = 59000;
    private int statisticInterval = -1;
    private int subscriptionAckInterval = 100;
    private int subscriptionMessageTrackingTimeout = 900000;
    private int subscriptionRedundancy = 0;
    private int subscriptionTimeoutMultiplier = 0;
    private long idleTimeout = 5000L;
    private long pingInterval = 10000L;
    private final ConnectionEndpointList locators = new ConnectionEndpointList();
    private final ConnectionEndpointList servers = new ConnectionEndpointList();
    private final ConnectionEndpointList xmlDeclaredLocators = new ConnectionEndpointList();
    private final ConnectionEndpointList xmlDeclaredServers = new ConnectionEndpointList();
    private List<PoolConfigurer> poolConfigurers = Collections.emptyList();
    private volatile Pool pool;
    private final PoolConfigurer xmlDeclaredServersPoolConfigurer = (beanName, bean) -> bean.addServers(this.xmlDeclaredServers);
    private final PoolConfigurer xmlDeclaredLocatorsPoolConfigurer = (beanName, bean) -> bean.addLocators(this.xmlDeclaredLocators);
    private final PoolConfigurer compositePoolConfigurer = (beanName, bean) -> {
        ArrayList<PoolConfigurer> allPoolConfigurers = new ArrayList<PoolConfigurer>(CollectionUtils.nullSafeSize(this.poolConfigurers) + 2);
        allPoolConfigurers.add(this.xmlDeclaredLocatorsPoolConfigurer);
        allPoolConfigurers.add(this.xmlDeclaredServersPoolConfigurer);
        allPoolConfigurers.addAll(CollectionUtils.nullSafeCollection(this.poolConfigurers));
        allPoolConfigurers.forEach(poolConfigurer -> poolConfigurer.configure(beanName, bean));
    };
    private PoolFactoryInitializer poolFactoryInitializer;
    private PoolResolver poolResolver = DEFAULT_POOL_RESOLVER;
    private SocketFactory socketFactory;
    private String name;
    private String serverGroup = "";

    public void afterPropertiesSet() throws Exception {
        this.init(this.resolvePool(this.resolvePoolName()));
    }

    private void init(@Nullable Pool existingPool) {
        if (existingPool != null) {
            this.pool = existingPool;
            this.springManagedPool = false;
            this.logDebug(() -> String.format("Pool [%s] already exists; Using existing Pool; PoolConfigurers will not be applied", this.pool.getName()));
        } else {
            this.logDebug("Pool [%s] not found; Lazily creating new Pool...", this.getName());
            this.applyPoolConfigurers();
        }
    }

    private Pool resolvePool(String name) {
        return this.getPoolResolver().resolve(name);
    }

    private String resolvePoolName() {
        if (!StringUtils.hasText((String)this.getName())) {
            this.setName(Optional.ofNullable(this.getBeanName()).filter(StringUtils::hasText).orElseThrow(() -> RuntimeExceptionFactory.newIllegalArgumentException("Pool name is required", new Object[0])));
        }
        return this.getName();
    }

    private void applyPoolConfigurers() {
        this.applyPoolConfigurers(this.getCompositePoolConfigurer());
    }

    protected void applyPoolConfigurers(PoolConfigurer ... poolConfigurers) {
        this.applyPoolConfigurers(Arrays.asList(ArrayUtils.nullSafeArray(poolConfigurers, PoolConfigurer.class)));
    }

    protected void applyPoolConfigurers(Iterable<PoolConfigurer> poolConfigurers) {
        StreamSupport.stream(CollectionUtils.nullSafeIterable(poolConfigurers).spliterator(), false).forEach(poolConfigurer -> poolConfigurer.configure(this.getName(), this));
    }

    public void destroy() {
        Optional.ofNullable(this.pool).filter(this::isSpringManagedPool).filter(pool -> !pool.isDestroyed()).ifPresent(pool -> {
            pool.releaseThreadLocalConnection();
            pool.destroy(this.keepAlive);
            this.setPool(null);
            this.logDebug("Destroyed Pool [%s]", pool.getName());
        });
    }

    private boolean isSpringManagedPool(Pool pool) {
        return this.springManagedPool;
    }

    public Pool getObject() throws Exception {
        return Optional.ofNullable(this.pool).orElseGet(() -> {
            this.eagerlyInitializeClientCache();
            String poolName = this.getName();
            Pool namedPool = this.resolvePool(poolName);
            this.pool = namedPool != null ? namedPool : this.postProcess(this.create(this.postProcess(this.configure(this.initialize(this.createPoolFactory()))), poolName));
            return this.pool;
        });
    }

    private void eagerlyInitializeClientCache() {
        if (!this.isClientCachePresent()) {
            this.getBeanFactory().getBean(ClientCache.class);
        }
    }

    boolean isClientCachePresent() {
        return Optional.ofNullable(GemfireUtils.getClientCache()).filter(clientCache -> !clientCache.isClosed()).map(GemFireCache::getDistributedSystem).filter(DistributedSystemUtils::isConnected).isPresent();
    }

    protected PoolFactory createPoolFactory() {
        return PoolManager.createFactory();
    }

    protected PoolFactory configure(PoolFactory poolFactory) {
        Optional.ofNullable(poolFactory).ifPresent(it -> {
            it.setFreeConnectionTimeout(this.freeConnectionTimeout);
            it.setIdleTimeout(this.idleTimeout);
            it.setLoadConditioningInterval(this.loadConditioningInterval);
            it.setMaxConnections(this.maxConnections);
            it.setMinConnections(this.minConnections);
            it.setMultiuserAuthentication(this.multiUserAuthentication);
            it.setPingInterval(this.pingInterval);
            it.setPRSingleHopEnabled(this.prSingleHopEnabled);
            it.setReadTimeout(this.readTimeout);
            it.setRetryAttempts(this.retryAttempts);
            it.setServerConnectionTimeout(this.serverConnectionTimeout);
            it.setServerGroup(this.serverGroup);
            it.setSocketBufferSize(this.socketBufferSize);
            it.setSocketConnectTimeout(this.socketConnectTimeout);
            it.setSocketFactory(this.getSocketFactory());
            it.setStatisticInterval(this.statisticInterval);
            it.setSubscriptionAckInterval(this.subscriptionAckInterval);
            it.setSubscriptionEnabled(this.subscriptionEnabled);
            it.setSubscriptionMessageTrackingTimeout(this.subscriptionMessageTrackingTimeout);
            it.setSubscriptionRedundancy(this.subscriptionRedundancy);
            it.setSubscriptionTimeoutMultiplier(this.subscriptionTimeoutMultiplier);
            it.setThreadLocalConnections(this.threadLocalConnections);
            CollectionUtils.nullSafeCollection(this.locators).forEach(locator -> it.addLocator(locator.getHost(), locator.getPort()));
            CollectionUtils.nullSafeCollection(this.servers).forEach(server -> it.addServer(server.getHost(), server.getPort()));
        });
        return poolFactory;
    }

    protected PoolFactory initialize(PoolFactory poolFactory) {
        return Optional.ofNullable(this.poolFactoryInitializer).map(initializer -> initializer.initialize(poolFactory)).orElse(poolFactory);
    }

    protected PoolFactory postProcess(PoolFactory poolFactory) {
        return poolFactory;
    }

    @Deprecated
    protected Pool create(PoolFactory poolFactory, String poolName) {
        return this.createPool(poolFactory, poolName);
    }

    protected Pool createPool(PoolFactory poolFactory, String poolName) {
        return poolFactory.create(poolName);
    }

    protected Pool postProcess(Pool pool) {
        return pool;
    }

    public Class<?> getObjectType() {
        return this.pool != null ? this.pool.getClass() : Pool.class;
    }

    public void addLocators(ConnectionEndpoint ... locators) {
        this.locators.add(locators);
    }

    public void addLocators(Iterable<ConnectionEndpoint> locators) {
        this.locators.add(locators);
    }

    public void addServers(ConnectionEndpoint ... servers) {
        this.servers.add(servers);
    }

    public void addServers(Iterable<ConnectionEndpoint> servers) {
        this.servers.add(servers);
    }

    protected PoolConfigurer getCompositePoolConfigurer() {
        return this.compositePoolConfigurer;
    }

    public void setName(String name) {
        this.name = name;
    }

    protected String getName() {
        return this.name;
    }

    public void setPool(@Nullable Pool pool) {
        this.pool = pool;
    }

    @NonNull
    public Pool getPool() {
        return Optional.ofNullable(this.pool).orElseGet(() -> new PoolAdapter(){

            @Override
            public boolean isDestroyed() {
                Pool pool = PoolFactoryBean.this.pool;
                return pool != null && pool.isDestroyed();
            }

            @Override
            public int getFreeConnectionTimeout() {
                return PoolFactoryBean.this.freeConnectionTimeout;
            }

            @Override
            public long getIdleTimeout() {
                return PoolFactoryBean.this.idleTimeout;
            }

            @Override
            public int getLoadConditioningInterval() {
                return PoolFactoryBean.this.loadConditioningInterval;
            }

            @Override
            public List<InetSocketAddress> getLocators() {
                return PoolFactoryBean.this.locators.toInetSocketAddresses();
            }

            @Override
            public List<InetSocketAddress> getOnlineLocators() {
                return Optional.ofNullable(PoolFactoryBean.this.pool).map(Pool::getOnlineLocators).orElseThrow(() -> RuntimeExceptionFactory.newIllegalStateException("Pool [%s] has not been initialized", this.getName()));
            }

            @Override
            public int getMaxConnections() {
                return PoolFactoryBean.this.maxConnections;
            }

            @Override
            public int getMinConnections() {
                return PoolFactoryBean.this.minConnections;
            }

            @Override
            public boolean getMultiuserAuthentication() {
                return PoolFactoryBean.this.multiUserAuthentication;
            }

            @Override
            public String getName() {
                return Optional.ofNullable(PoolFactoryBean.this.getName()).filter(StringUtils::hasText).orElseGet(PoolFactoryBean.this::getBeanName);
            }

            @Override
            public int getPendingEventCount() {
                return Optional.ofNullable(PoolFactoryBean.this.pool).map(Pool::getPendingEventCount).orElseThrow(() -> RuntimeExceptionFactory.newIllegalStateException("Pool [%s] has not been initialized", this.getName()));
            }

            @Override
            public long getPingInterval() {
                return PoolFactoryBean.this.pingInterval;
            }

            @Override
            public boolean getPRSingleHopEnabled() {
                return PoolFactoryBean.this.prSingleHopEnabled;
            }

            @Override
            public QueryService getQueryService() {
                return Optional.ofNullable(PoolFactoryBean.this.pool).map(Pool::getQueryService).orElseThrow(() -> RuntimeExceptionFactory.newIllegalStateException("Pool [%s] has not been initialized", this.getName()));
            }

            @Override
            public int getReadTimeout() {
                return PoolFactoryBean.this.readTimeout;
            }

            @Override
            public int getRetryAttempts() {
                return PoolFactoryBean.this.retryAttempts;
            }

            @Override
            public int getServerConnectionTimeout() {
                return PoolFactoryBean.this.serverConnectionTimeout;
            }

            @Override
            public String getServerGroup() {
                return PoolFactoryBean.this.serverGroup;
            }

            @Override
            public List<InetSocketAddress> getServers() {
                return PoolFactoryBean.this.servers.toInetSocketAddresses();
            }

            @Override
            public int getSocketBufferSize() {
                return PoolFactoryBean.this.socketBufferSize;
            }

            @Override
            public int getSocketConnectTimeout() {
                return PoolFactoryBean.this.socketConnectTimeout;
            }

            @Override
            public SocketFactory getSocketFactory() {
                return PoolFactoryBean.this.getSocketFactory();
            }

            @Override
            public int getStatisticInterval() {
                return PoolFactoryBean.this.statisticInterval;
            }

            @Override
            public int getSubscriptionAckInterval() {
                return PoolFactoryBean.this.subscriptionAckInterval;
            }

            @Override
            public boolean getSubscriptionEnabled() {
                return PoolFactoryBean.this.subscriptionEnabled;
            }

            @Override
            public int getSubscriptionMessageTrackingTimeout() {
                return PoolFactoryBean.this.subscriptionMessageTrackingTimeout;
            }

            @Override
            public int getSubscriptionRedundancy() {
                return PoolFactoryBean.this.subscriptionRedundancy;
            }

            @Override
            public int getSubscriptionTimeoutMultiplier() {
                return PoolFactoryBean.this.subscriptionTimeoutMultiplier;
            }

            @Override
            public boolean getThreadLocalConnections() {
                return PoolFactoryBean.this.threadLocalConnections;
            }

            @Override
            public void destroy() {
                this.destroy(false);
            }

            @Override
            public void destroy(boolean keepAlive) {
                try {
                    PoolFactoryBean.this.destroy();
                }
                catch (Exception ignore) {
                    Optional.ofNullable(PoolFactoryBean.this.pool).ifPresent(pool -> pool.destroy(keepAlive));
                }
            }

            @Override
            public void releaseThreadLocalConnection() {
                Optional.ofNullable(PoolFactoryBean.this.pool).map(it -> {
                    it.releaseThreadLocalConnection();
                    return it;
                }).orElseThrow(() -> RuntimeExceptionFactory.newIllegalStateException("Pool [%s] has not been initialized", this.getName()));
            }
        });
    }

    public void setFreeConnectionTimeout(int freeConnectionTimeout) {
        this.freeConnectionTimeout = freeConnectionTimeout;
    }

    public void setIdleTimeout(long idleTimeout) {
        this.idleTimeout = idleTimeout;
    }

    public void setKeepAlive(boolean keepAlive) {
        this.keepAlive = keepAlive;
    }

    public void setLoadConditioningInterval(int loadConditioningInterval) {
        this.loadConditioningInterval = loadConditioningInterval;
    }

    public void setLocators(ConnectionEndpoint[] locators) {
        this.setLocators(ConnectionEndpointList.from(locators));
    }

    public void setLocators(Iterable<ConnectionEndpoint> locators) {
        this.getLocators().clear();
        this.getLocators().add(locators);
    }

    ConnectionEndpointList getLocators() {
        return this.locators;
    }

    public void setMaxConnections(int maxConnections) {
        this.maxConnections = maxConnections;
    }

    public void setMinConnections(int minConnections) {
        this.minConnections = minConnections;
    }

    public void setMultiUserAuthentication(boolean multiUserAuthentication) {
        this.multiUserAuthentication = multiUserAuthentication;
    }

    public void setPingInterval(long pingInterval) {
        this.pingInterval = pingInterval;
    }

    public void setPoolConfigurers(PoolConfigurer ... poolConfigurers) {
        this.setPoolConfigurers(Arrays.asList(ArrayUtils.nullSafeArray(poolConfigurers, PoolConfigurer.class)));
    }

    public void setPoolConfigurers(List<PoolConfigurer> poolConfigurers) {
        this.poolConfigurers = Optional.ofNullable(poolConfigurers).orElseGet(Collections::emptyList);
    }

    public void setPoolFactoryInitializer(PoolFactoryInitializer poolFactoryInitializer) {
        this.poolFactoryInitializer = poolFactoryInitializer;
    }

    public void setPoolResolver(PoolResolver poolResolver) {
        this.poolResolver = poolResolver;
    }

    public PoolResolver getPoolResolver() {
        PoolResolver poolResolver = this.poolResolver;
        return poolResolver != null ? poolResolver : DEFAULT_POOL_RESOLVER;
    }

    public void setPrSingleHopEnabled(boolean prSingleHopEnabled) {
        this.prSingleHopEnabled = prSingleHopEnabled;
    }

    public void setReadTimeout(int readTimeout) {
        this.readTimeout = readTimeout;
    }

    public void setRetryAttempts(int retryAttempts) {
        this.retryAttempts = retryAttempts;
    }

    public void setServerConnectionTimeout(int serverConnectionTimeout) {
        this.serverConnectionTimeout = serverConnectionTimeout;
    }

    public void setServerGroup(String serverGroup) {
        this.serverGroup = serverGroup;
    }

    public void setServers(ConnectionEndpoint[] servers) {
        this.setServers(ConnectionEndpointList.from(servers));
    }

    public void setServers(Iterable<ConnectionEndpoint> servers) {
        this.getServers().clear();
        this.getServers().add(servers);
    }

    ConnectionEndpointList getServers() {
        return this.servers;
    }

    public void setSocketBufferSize(int socketBufferSize) {
        this.socketBufferSize = socketBufferSize;
    }

    public void setSocketConnectTimeout(int socketConnectTimeout) {
        this.socketConnectTimeout = socketConnectTimeout;
    }

    public void setSocketFactory(SocketFactory socketFactory) {
        this.socketFactory = socketFactory;
    }

    protected SocketFactory getSocketFactory() {
        return this.socketFactory != null ? this.socketFactory : PoolFactory.DEFAULT_SOCKET_FACTORY;
    }

    public void setStatisticInterval(int statisticInterval) {
        this.statisticInterval = statisticInterval;
    }

    public void setSubscriptionAckInterval(int subscriptionAckInterval) {
        this.subscriptionAckInterval = subscriptionAckInterval;
    }

    public void setSubscriptionEnabled(boolean subscriptionEnabled) {
        this.subscriptionEnabled = subscriptionEnabled;
    }

    public void setSubscriptionMessageTrackingTimeout(int subscriptionMessageTrackingTimeout) {
        this.subscriptionMessageTrackingTimeout = subscriptionMessageTrackingTimeout;
    }

    public void setSubscriptionRedundancy(int subscriptionRedundancy) {
        this.subscriptionRedundancy = subscriptionRedundancy;
    }

    public void setSubscriptionTimeoutMultiplier(int subscriptionTimeoutMultiplier) {
        this.subscriptionTimeoutMultiplier = subscriptionTimeoutMultiplier;
    }

    @Deprecated
    public void setThreadLocalConnections(boolean threadLocalConnections) {
        this.threadLocalConnections = threadLocalConnections;
    }

    public void setXmlDeclaredLocators(ConnectionEndpointList xmlDeclaredLocators) {
        this.xmlDeclaredLocators.add(xmlDeclaredLocators);
    }

    public void setXmlDeclaredServers(ConnectionEndpointList xmlDeclaredServers) {
        this.xmlDeclaredServers.add(xmlDeclaredServers);
    }

    public static interface PoolFactoryInitializer {
        public PoolFactory initialize(PoolFactory var1);
    }
}

