/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.transaction;

import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.apache.geode.cache.CacheTransactionManager;
import org.apache.geode.cache.GemFireCache;
import org.apache.geode.cache.Region;
import org.apache.geode.cache.TransactionId;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.data.gemfire.transaction.GemfireTransactionCommitException;
import org.springframework.transaction.CannotCreateTransactionException;
import org.springframework.transaction.NoTransactionException;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionException;
import org.springframework.transaction.support.AbstractPlatformTransactionManager;
import org.springframework.transaction.support.DefaultTransactionStatus;
import org.springframework.transaction.support.ResourceTransactionManager;
import org.springframework.transaction.support.TransactionSynchronizationManager;
import org.springframework.util.Assert;

public class GemfireTransactionManager
extends AbstractPlatformTransactionManager
implements InitializingBean,
ResourceTransactionManager {
    protected static final TimeUnit DEFAULT_RESUME_WAIT_TIME_UNIT = TimeUnit.SECONDS;
    private GemFireCache cache;
    private boolean copyOnRead = true;
    private Long resumeWaitTime;
    private TimeUnit resumeWaitTimeUnit = DEFAULT_RESUME_WAIT_TIME_UNIT;

    public GemfireTransactionManager() {
    }

    public GemfireTransactionManager(GemFireCache cache) {
        this.cache = cache;
        this.afterPropertiesSet();
    }

    public void afterPropertiesSet() {
        Assert.notNull((Object)this.cache, (String)"Cache is required");
        this.cache.setCopyOnRead(this.isCopyOnRead());
    }

    protected Object doGetTransaction() throws TransactionException {
        return CacheTransactionObject.newCacheTransactionObject((CacheHolder)TransactionSynchronizationManager.getResource((Object)this.getCache()));
    }

    protected boolean isExistingTransaction(Object transaction) throws TransactionException {
        return ((CacheTransactionObject)transaction).isHolding();
    }

    protected void doBegin(Object transaction, TransactionDefinition definition) throws TransactionException {
        try {
            CacheTransactionObject cacheTransaction = (CacheTransactionObject)transaction;
            GemFireCache cache = this.getCache();
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)String.format("Acquired GemFire Cache [%s] for local cache transaction", cache));
            }
            CacheTransactionManager cacheTransactionManager = this.getCacheTransactionManager();
            cacheTransactionManager.begin();
            TransactionId transactionId = cacheTransactionManager.getTransactionId();
            if (transactionId != null) {
                TransactionSynchronizationManager.bindResource((Object)cache, (Object)cacheTransaction.setAndGetHolder(CacheHolder.newCacheHolder(transactionId)));
            }
        }
        catch (Exception cause) {
            throw new CannotCreateTransactionException(String.format("%1$s; %2$s", "An existing, ongoing transaction is already associated with the current thread.", " Are multiple transaction managers present?"), (Throwable)cause);
        }
    }

    protected void doCommit(DefaultTransactionStatus status) throws TransactionException {
        try {
            if (status.isDebug()) {
                this.logger.debug((Object)"Committing local cache transaction");
            }
            this.getCacheTransactionManager().commit();
        }
        catch (org.apache.geode.cache.TransactionException cause) {
            throw new GemfireTransactionCommitException("Unexpected failure occurred on commit of local cache transaction", cause);
        }
        catch (Exception cause) {
            throw new NoTransactionException("No transaction is associated with the current thread. Are multiple transaction managers present?", (Throwable)cause);
        }
    }

    protected Object doSuspend(Object transaction) throws TransactionException {
        if (this.getCacheTransactionManager().suspend() != null) {
            TransactionSynchronizationManager.unbindResource((Object)this.getCache());
            return ((CacheTransactionObject)transaction).setAndGetExistingHolder(null);
        }
        return null;
    }

    protected void doResume(Object transaction, Object suspendedResources) throws TransactionException {
        if (suspendedResources instanceof CacheHolder) {
            boolean resumeSuccessful;
            CacheHolder holder = (CacheHolder)suspendedResources;
            boolean bl = resumeSuccessful = this.isResumeWaitTimeSet() ? this.getCacheTransactionManager().tryResume(holder.getTransactionId(), this.getResumeWaitTime().longValue(), this.getResumeWaitTimeUnit()) : this.getCacheTransactionManager().tryResume(holder.getTransactionId());
            if (resumeSuccessful) {
                TransactionSynchronizationManager.bindResource((Object)this.getCache(), (Object)((CacheTransactionObject)transaction).setAndGetHolder(holder));
            }
        }
    }

    protected void doRollback(DefaultTransactionStatus status) throws TransactionException {
        try {
            if (status.isDebug()) {
                this.logger.debug((Object)"Rolling back local cache transaction");
            }
            this.getCacheTransactionManager().rollback();
        }
        catch (Exception cause) {
            String exceptionMessage = "No transaction is associated with the current thread. Are multiple transaction managers present?";
            throw new NoTransactionException(exceptionMessage, (Throwable)cause);
        }
    }

    protected void doCleanupAfterCompletion(Object transaction) {
        TransactionSynchronizationManager.unbindResource((Object)this.getCache());
    }

    protected void doSetRollbackOnly(DefaultTransactionStatus status) {
        ((CacheTransactionObject)status.getTransaction()).getHolder().setRollbackOnly();
    }

    protected final boolean useSavepointForNestedTransaction() {
        return false;
    }

    public void setCache(GemFireCache cache) {
        this.cache = cache;
    }

    public GemFireCache getCache() {
        return this.cache;
    }

    protected CacheTransactionManager getCacheTransactionManager() {
        return this.getCache().getCacheTransactionManager();
    }

    public void setCopyOnRead(boolean copyOnRead) {
        this.copyOnRead = copyOnRead;
    }

    public boolean isCopyOnRead() {
        return this.copyOnRead;
    }

    public <K, V> void setRegion(Region<K, V> region) {
        Assert.notNull(region, (String)"Region must not be null");
        this.cache = (GemFireCache)region.getRegionService();
    }

    public Object getResourceFactory() {
        return this.getCache();
    }

    public void setResumeWaitTime(Long resumeWaitTime) {
        this.resumeWaitTime = resumeWaitTime;
    }

    protected Long getResumeWaitTime() {
        return this.resumeWaitTime;
    }

    protected boolean isResumeWaitTimeSet() {
        Long resumeWaitTime = this.getResumeWaitTime();
        return resumeWaitTime != null && resumeWaitTime > 0L;
    }

    public void setResumeWaitTimeUnit(TimeUnit resumeWaitTimeUnit) {
        this.resumeWaitTimeUnit = resumeWaitTimeUnit;
    }

    protected TimeUnit getResumeWaitTimeUnit() {
        return Optional.ofNullable(this.resumeWaitTimeUnit).orElse(DEFAULT_RESUME_WAIT_TIME_UNIT);
    }

    protected static class CacheHolder {
        private boolean rollbackOnly = false;
        private TransactionId transactionId;

        protected CacheHolder() {
        }

        static CacheHolder newCacheHolder(TransactionId transactionId) {
            CacheHolder cacheHolder = new CacheHolder();
            cacheHolder.transactionId = transactionId;
            return cacheHolder;
        }

        void setRollbackOnly() {
            this.rollbackOnly = true;
        }

        boolean isRollbackOnly() {
            return this.rollbackOnly;
        }

        TransactionId getTransactionId() {
            return this.transactionId;
        }
    }

    protected static class CacheTransactionObject {
        private CacheHolder cacheHolder;

        protected CacheTransactionObject() {
        }

        static CacheTransactionObject newCacheTransactionObject(CacheHolder cacheHolder) {
            CacheTransactionObject transactionObject = new CacheTransactionObject();
            transactionObject.setHolder(cacheHolder);
            return transactionObject;
        }

        CacheHolder setAndGetExistingHolder(CacheHolder cacheHolder) {
            CacheHolder existingHolder = this.getHolder();
            this.setHolder(cacheHolder);
            return existingHolder;
        }

        CacheHolder setAndGetHolder(CacheHolder holder) {
            this.setHolder(holder);
            return this.getHolder();
        }

        void setHolder(CacheHolder cacheHolder) {
            this.cacheHolder = cacheHolder;
        }

        CacheHolder getHolder() {
            return this.cacheHolder;
        }

        boolean isHolding() {
            return this.getHolder() != null;
        }
    }
}

