/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.support;

import java.net.InetSocketAddress;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.function.Predicate;
import org.springframework.data.gemfire.support.ConnectionEndpoint;
import org.springframework.data.gemfire.util.ArrayUtils;
import org.springframework.data.gemfire.util.CollectionUtils;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import org.springframework.util.StringUtils;

public class ConnectionEndpointList
extends AbstractList<ConnectionEndpoint> {
    private final List<ConnectionEndpoint> connectionEndpoints = new ArrayList<ConnectionEndpoint>();

    public static ConnectionEndpointList from(ConnectionEndpoint ... connectionEndpoints) {
        return new ConnectionEndpointList(connectionEndpoints);
    }

    public static ConnectionEndpointList from(InetSocketAddress ... socketAddresses) {
        return ConnectionEndpointList.from(Arrays.asList(socketAddresses));
    }

    public static ConnectionEndpointList from(Iterable<InetSocketAddress> socketAddresses) {
        ArrayList<ConnectionEndpoint> connectionEndpoints = new ArrayList<ConnectionEndpoint>();
        for (InetSocketAddress socketAddress : CollectionUtils.nullSafeIterable(socketAddresses)) {
            connectionEndpoints.add(ConnectionEndpoint.from(socketAddress));
        }
        return new ConnectionEndpointList(connectionEndpoints);
    }

    public static ConnectionEndpointList parse(String commaDelimitedHostAndPorts, int defaultPort) {
        String[] hostsPorts = StringUtils.commaDelimitedListToStringArray((String)commaDelimitedHostAndPorts);
        return ConnectionEndpointList.parse(defaultPort, hostsPorts);
    }

    public static ConnectionEndpointList parse(int defaultPort, String ... hostsPorts) {
        ArrayList<ConnectionEndpoint> connectionEndpoints = new ArrayList<ConnectionEndpoint>(ArrayUtils.length(hostsPorts));
        for (String hostPort : ArrayUtils.nullSafeArray(hostsPorts, String.class)) {
            connectionEndpoints.add(ConnectionEndpoint.parse(hostPort, defaultPort));
        }
        return new ConnectionEndpointList(connectionEndpoints);
    }

    public ConnectionEndpointList() {
        this(Collections.emptyList());
    }

    public ConnectionEndpointList(ConnectionEndpoint ... connectionEndpoints) {
        this(Arrays.asList(connectionEndpoints));
    }

    public ConnectionEndpointList(@NonNull Iterable<ConnectionEndpoint> connectionEndpoints) {
        this.add(connectionEndpoints);
    }

    @Override
    public boolean add(ConnectionEndpoint connectionEndpoint) {
        return this.add(ArrayUtils.asArray(connectionEndpoint)) == this;
    }

    public final ConnectionEndpointList add(ConnectionEndpoint ... connectionEndpoints) {
        Collections.addAll(this.connectionEndpoints, connectionEndpoints);
        return this;
    }

    public final ConnectionEndpointList add(Iterable<ConnectionEndpoint> connectionEndpoints) {
        for (ConnectionEndpoint connectionEndpoint : CollectionUtils.nullSafeIterable(connectionEndpoints)) {
            this.connectionEndpoints.add(connectionEndpoint);
        }
        return this;
    }

    @Override
    public void clear() {
        this.connectionEndpoints.clear();
    }

    @NonNull
    private ConnectionEndpointList findBy(@NonNull Predicate<ConnectionEndpoint> predicate) {
        ArrayList<ConnectionEndpoint> connectionEndpoints = new ArrayList<ConnectionEndpoint>(this.size());
        for (ConnectionEndpoint connectionEndpoint : this) {
            if (!predicate.test(connectionEndpoint)) continue;
            connectionEndpoints.add(connectionEndpoint);
        }
        return new ConnectionEndpointList(connectionEndpoints);
    }

    @NonNull
    public ConnectionEndpointList findBy(String host) {
        return this.findBy((ConnectionEndpoint connectionEndpoint) -> connectionEndpoint.getHost().equals(host));
    }

    @NonNull
    public ConnectionEndpointList findBy(int port) {
        return this.findBy((ConnectionEndpoint connectionEndpoint) -> connectionEndpoint.getPort() == port);
    }

    @Nullable
    private ConnectionEndpoint findOne(@NonNull ConnectionEndpointList list) {
        return list == null || list.isEmpty() ? null : list.get(0);
    }

    @Nullable
    public ConnectionEndpoint findOne(String host) {
        return this.findOne(this.findBy(host));
    }

    @Nullable
    public ConnectionEndpoint findOne(int port) {
        return this.findOne(this.findBy(port));
    }

    @Override
    public ConnectionEndpoint get(int index) {
        return this.connectionEndpoints.get(index);
    }

    @Override
    public ConnectionEndpoint set(int index, ConnectionEndpoint element) {
        return this.connectionEndpoints.set(index, element);
    }

    @Override
    public boolean isEmpty() {
        return this.connectionEndpoints.isEmpty();
    }

    @Override
    @NonNull
    public Iterator<ConnectionEndpoint> iterator() {
        return Collections.unmodifiableList(this.connectionEndpoints).iterator();
    }

    @Override
    public int size() {
        return this.connectionEndpoints.size();
    }

    public ConnectionEndpoint[] toArray() {
        return this.connectionEndpoints.toArray(new ConnectionEndpoint[0]);
    }

    public List<InetSocketAddress> toInetSocketAddresses() {
        ArrayList<InetSocketAddress> inetSocketAddresses = new ArrayList<InetSocketAddress>(this.size());
        for (ConnectionEndpoint connectionEndpoint : this) {
            inetSocketAddresses.add(connectionEndpoint.toInetSocketAddress());
        }
        return inetSocketAddresses;
    }

    @Override
    public String toString() {
        return this.connectionEndpoints.toString();
    }
}

