/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.search.lucene;

import java.util.Collection;
import java.util.List;
import org.apache.geode.cache.Region;
import org.apache.geode.cache.lucene.LuceneIndex;
import org.apache.geode.cache.lucene.LuceneQuery;
import org.apache.geode.cache.lucene.LuceneQueryFactory;
import org.apache.geode.cache.lucene.LuceneQueryProvider;
import org.apache.geode.cache.lucene.LuceneResultStruct;
import org.apache.geode.cache.lucene.PageableLuceneQueryResults;
import org.springframework.data.gemfire.search.lucene.LuceneOperations;
import org.springframework.data.gemfire.search.lucene.support.LuceneAccessorSupport;

public class LuceneTemplate
extends LuceneAccessorSupport
implements LuceneOperations {
    public LuceneTemplate() {
    }

    public LuceneTemplate(LuceneIndex luceneIndex) {
        super(luceneIndex);
    }

    public LuceneTemplate(String indexName, Region<?, ?> region) {
        super(indexName, region);
    }

    public LuceneTemplate(String indexName, String regionPath) {
        super(indexName, regionPath);
    }

    @Override
    public <K, V> List<LuceneResultStruct<K, V>> query(String query, String defaultField, int resultLimit) {
        String indexName = this.resolveIndexName();
        String regionPath = this.resolveRegionPath();
        LuceneQueryFactory queryFactory = this.createLuceneQueryFactory(resultLimit);
        LuceneQuery queryWrapper = queryFactory.create(indexName, regionPath, query, defaultField);
        return this.doFind(() -> ((LuceneQuery)queryWrapper).findResults(), query, regionPath, indexName);
    }

    @Override
    public <K, V> PageableLuceneQueryResults<K, V> query(String query, String defaultField, int resultLimit, int pageSize) {
        String indexName = this.resolveIndexName();
        String regionPath = this.resolveRegionPath();
        LuceneQueryFactory queryFactory = this.createLuceneQueryFactory(resultLimit, pageSize);
        LuceneQuery queryWrapper = queryFactory.create(indexName, regionPath, query, defaultField);
        return this.doFind(() -> ((LuceneQuery)queryWrapper).findPages(), query, regionPath, indexName);
    }

    @Override
    public <K, V> List<LuceneResultStruct<K, V>> query(LuceneQueryProvider queryProvider, int resultLimit) {
        String indexName = this.resolveIndexName();
        String regionPath = this.resolveRegionPath();
        LuceneQueryFactory queryFactory = this.createLuceneQueryFactory(resultLimit);
        LuceneQuery queryWrapper = queryFactory.create(indexName, regionPath, queryProvider);
        return this.doFind(() -> ((LuceneQuery)queryWrapper).findResults(), queryProvider, regionPath, indexName);
    }

    @Override
    public <K, V> PageableLuceneQueryResults<K, V> query(LuceneQueryProvider queryProvider, int resultLimit, int pageSize) {
        String indexName = this.resolveIndexName();
        String regionPath = this.resolveRegionPath();
        LuceneQueryFactory queryFactory = this.createLuceneQueryFactory(resultLimit, pageSize);
        LuceneQuery queryWrapper = queryFactory.create(indexName, regionPath, queryProvider);
        return this.doFind(() -> ((LuceneQuery)queryWrapper).findPages(), queryProvider, regionPath, indexName);
    }

    @Override
    public <K> Collection<K> queryForKeys(String query, String defaultField, int resultLimit) {
        String indexName = this.resolveIndexName();
        String regionPath = this.resolveRegionPath();
        LuceneQueryFactory queryFactory = this.createLuceneQueryFactory(resultLimit);
        LuceneQuery queryWrapper = queryFactory.create(indexName, regionPath, query, defaultField);
        return this.doFind(() -> ((LuceneQuery)queryWrapper).findKeys(), query, regionPath, indexName);
    }

    @Override
    public <K> Collection<K> queryForKeys(LuceneQueryProvider queryProvider, int resultLimit) {
        String indexName = this.resolveIndexName();
        String regionPath = this.resolveRegionPath();
        LuceneQueryFactory queryFactory = this.createLuceneQueryFactory(resultLimit);
        LuceneQuery queryWrapper = queryFactory.create(indexName, regionPath, queryProvider);
        return this.doFind(() -> ((LuceneQuery)queryWrapper).findKeys(), queryProvider, regionPath, indexName);
    }

    @Override
    public <V> Collection<V> queryForValues(String query, String defaultField, int resultLimit) {
        String indexName = this.resolveIndexName();
        String regionPath = this.resolveRegionPath();
        LuceneQueryFactory queryFactory = this.createLuceneQueryFactory(resultLimit);
        LuceneQuery queryWrapper = queryFactory.create(indexName, regionPath, query, defaultField);
        return this.doFind(() -> ((LuceneQuery)queryWrapper).findValues(), query, regionPath, indexName);
    }

    @Override
    public <V> Collection<V> queryForValues(LuceneQueryProvider queryProvider, int resultLimit) {
        String indexName = this.resolveIndexName();
        String regionPath = this.resolveRegionPath();
        LuceneQueryFactory queryFactory = this.createLuceneQueryFactory(resultLimit);
        LuceneQuery queryWrapper = queryFactory.create(indexName, regionPath, queryProvider);
        return this.doFind(() -> ((LuceneQuery)queryWrapper).findValues(), queryProvider, regionPath, indexName);
    }
}

