/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.domain;

import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Sort;
import org.springframework.data.gemfire.domain.support.AbstractPageSupport;
import org.springframework.lang.Nullable;

public class ListablePage<T>
extends AbstractPageSupport<T> {
    private final List<T> content;

    @SafeVarargs
    public static <T> ListablePage<T> newListablePage(T ... content) {
        return new ListablePage<T>(Arrays.asList(content));
    }

    public static <T> ListablePage<T> newListablePage(@Nullable List<T> content) {
        return new ListablePage<T>(content);
    }

    public ListablePage(@Nullable List<T> content) {
        this.content = content != null ? content : Collections.emptyList();
    }

    @Override
    public boolean hasContent() {
        return !this.getContent().isEmpty();
    }

    @Override
    public boolean hasNext() {
        return false;
    }

    @Override
    public boolean hasPrevious() {
        return false;
    }

    @Override
    public List<T> getContent() {
        return Collections.unmodifiableList(this.content);
    }

    @Override
    public int getNumber() {
        return 1;
    }

    @Override
    public Sort getSort() {
        return null;
    }

    @Override
    public long getTotalElements() {
        return this.getSize();
    }

    @Override
    public int getTotalPages() {
        return 1;
    }

    @Override
    public Iterator<T> iterator() {
        return this.getContent().iterator();
    }

    @Override
    public <S> Page<S> map(Function<? super T, ? extends S> converter) {
        return ListablePage.newListablePage(this.getContent().stream().map(converter).collect(Collectors.toList()));
    }
}

