/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.config.support;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Optional;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.data.gemfire.config.support.AbstractDependencyStructuringBeanFactoryPostProcessor;
import org.springframework.data.gemfire.search.lucene.LuceneIndexFactoryBean;
import org.springframework.util.StringUtils;

public class LuceneIndexRegionBeanFactoryPostProcessor
extends AbstractDependencyStructuringBeanFactoryPostProcessor {
    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        HashMap regionNameToLuceneIndexBeanName = new HashMap();
        HashMap regionNameToRegionBeanName = new HashMap();
        Arrays.stream(beanFactory.getBeanDefinitionNames()).forEach(beanName -> {
            BeanDefinition beanDefinition = beanFactory.getBeanDefinition(beanName);
            if (this.isBeanDefinitionOfType(beanDefinition, LuceneIndexFactoryBean.class)) {
                this.resolveRegionNameFromLuceneIndex(beanDefinition).ifPresent(regionName -> regionNameToLuceneIndexBeanName.put(regionName, beanName));
            } else if (this.isBeanDefinitionOfType(beanDefinition, this.isRegionBeanType())) {
                this.resolveRegionNameFromRegionBean((String)beanName, beanDefinition).ifPresent(regionName -> regionNameToRegionBeanName.put(regionName, beanName));
            }
        });
        regionNameToRegionBeanName.keySet().stream().forEach(regionName -> {
            if (regionNameToLuceneIndexBeanName.containsKey(regionName)) {
                String regionBeanName = (String)regionNameToRegionBeanName.get(regionName);
                String luceneIndexBeanName = (String)regionNameToLuceneIndexBeanName.get(regionName);
                this.addDependsOn(beanFactory.getBeanDefinition(regionBeanName), luceneIndexBeanName);
            }
        });
    }

    private Optional<String> resolveRegionNameFromLuceneIndex(BeanDefinition beanDefinition) {
        return this.getPropertyValue(beanDefinition, "regionPath").map(this::asFullyQualifiedRegionName);
    }

    private Optional<String> resolveRegionNameFromRegionBean(String beanName, BeanDefinition beanDefinition) {
        String regionName = this.asString(this.getPropertyValue(beanDefinition, "regionName"));
        String name = this.asString(this.getPropertyValue(beanDefinition, "name"));
        return Optional.ofNullable(StringUtils.hasText((String)regionName) ? regionName : (StringUtils.hasText((String)name) ? name : beanName)).filter(StringUtils::hasText);
    }

    private String asFullyQualifiedRegionName(Object regionPath) {
        return Optional.ofNullable(regionPath).map(String::valueOf).map(String::trim).map(it -> {
            int index = it.lastIndexOf("/");
            return index > 0 ? it : it.substring(1);
        }).filter(StringUtils::hasText).orElse(null);
    }

    private String asString(Optional<Object> value) {
        return value.map(String::valueOf).map(String::trim).filter(StringUtils::hasText).orElse(null);
    }
}

