/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.config.support;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.beans.BeansException;
import org.springframework.beans.PropertyValue;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.gemfire.PeerRegionFactoryBean;
import org.springframework.data.gemfire.config.annotation.support.AbstractAnnotationConfigSupport;
import org.springframework.data.gemfire.util.ArrayUtils;
import org.springframework.data.gemfire.wan.GatewaySenderFactoryBean;

@Configuration
public class GatewaySenderBeanFactoryPostProcessor
extends AbstractAnnotationConfigSupport {
    @Override
    protected Class<? extends Annotation> getAnnotationType() {
        return null;
    }

    @Bean
    public BeanFactoryPostProcessor postProcessBeanFactory() throws BeansException {
        return beanFactory -> {
            Map<String, Map<String, BeanDefinition>> cachedBeanDefinitions = this.populateBeanDefinitionCache(beanFactory);
            Map<String, List<String>> gatewaySenderToRegions = this.groupGatewaySenderPerRegion(cachedBeanDefinitions, new HashMap<String, List<String>>());
            this.addGatewaySendersToRegionFactory(beanFactory, gatewaySenderToRegions);
        };
    }

    private Map<String, Map<String, BeanDefinition>> populateBeanDefinitionCache(ConfigurableListableBeanFactory beanFactory) {
        LinkedHashMap<String, Map<String, BeanDefinition>> cachedBeanDefinitions = new LinkedHashMap<String, Map<String, BeanDefinition>>();
        Arrays.stream(ArrayUtils.nullSafeArray(beanFactory.getBeanDefinitionNames(), String.class)).forEach(beanName -> {
            BeanDefinition beanDefinition = beanFactory.getBeanDefinition(beanName);
            if (this.isRegionBean(beanDefinition, beanFactory)) {
                this.addBeanDefinitionToList((String)beanName, beanDefinition, (Map<String, Map<String, BeanDefinition>>)cachedBeanDefinitions, "regions");
            } else if (this.isGatewaySenderFactoryBean(beanDefinition)) {
                this.addBeanDefinitionToList((String)beanName, beanDefinition, (Map<String, Map<String, BeanDefinition>>)cachedBeanDefinitions, "gatewaySenders");
            }
        });
        return cachedBeanDefinitions;
    }

    private boolean isRegionBean(BeanDefinition beanDefinition, ConfigurableListableBeanFactory beanFactory) {
        return Optional.ofNullable(beanDefinition).flatMap(it -> this.resolveBeanClass(beanDefinition, (ConfigurableBeanFactory)beanFactory)).filter(PeerRegionFactoryBean.class::isAssignableFrom).isPresent();
    }

    private boolean isGatewaySenderFactoryBean(BeanDefinition beanDefinition) {
        return GatewaySenderFactoryBean.class.getName().equals(beanDefinition.getBeanClassName());
    }

    private Map<String, Map<String, BeanDefinition>> addBeanDefinitionToList(String beanName, BeanDefinition beanDefinition, Map<String, Map<String, BeanDefinition>> cachedBeanDefinitions, String key) {
        Map beanDefinitions = cachedBeanDefinitions.computeIfAbsent(key, k -> new HashMap());
        beanDefinitions.put(beanName, beanDefinition);
        return cachedBeanDefinitions;
    }

    private Map<String, List<String>> groupGatewaySenderPerRegion(Map<String, Map<String, BeanDefinition>> cachedBeanDefinitions, Map<String, List<String>> gatewaySendersPerRegion) {
        Optional<Map<String, BeanDefinition>> gatewaySenders = Optional.ofNullable(cachedBeanDefinitions.get("gatewaySenders"));
        gatewaySenders.ifPresent(gatewaySendersMap -> gatewaySendersMap.forEach((key, gatewaySenderBean) -> {
            PropertyValue regions = gatewaySenderBean.getPropertyValues().getPropertyValue("regions");
            ArrayList<String> namedRegions = new ArrayList<String>();
            Optional.ofNullable(regions).map(PropertyValue::getValue).filter(String[].class::isInstance).map(String[].class::cast).map(Arrays::asList).ifPresent(namedRegions::addAll);
            ArrayList<String> regionNames = !namedRegions.isEmpty() ? namedRegions : ((Map)cachedBeanDefinitions.get("regions")).keySet();
            this.addGatewaySendersToRegion(gatewaySendersPerRegion, (String)key, (Collection<String>)regionNames);
        }));
        return gatewaySendersPerRegion;
    }

    private void addGatewaySendersToRegionFactory(ConfigurableListableBeanFactory beanFactory, Map<String, List<String>> gatewaySenderToRegions) {
        gatewaySenderToRegions.forEach((key, value) -> {
            ManagedList runtimeBeanReferences = value.stream().map(RuntimeBeanReference::new).collect(Collectors.toCollection(() -> new ManagedList()));
            Optional.ofNullable(beanFactory.getBeanDefinition(key)).ifPresent(regionBeanDefinition -> regionBeanDefinition.getPropertyValues().addPropertyValue("gatewaySenders", (Object)runtimeBeanReferences));
        });
    }

    private void addGatewaySendersToRegion(Map<String, List<String>> regionMapping, String gatewaySenderName, Collection<String> regionNames) {
        regionNames.forEach(regionName -> {
            List gatewaySenders = regionMapping.computeIfAbsent((String)regionName, k -> new ArrayList());
            gatewaySenders.add(gatewaySenderName);
        });
    }
}

