/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.config.annotation;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Inherited;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.Arrays;
import org.springframework.context.annotation.Import;
import org.springframework.data.gemfire.config.annotation.SslConfiguration;
import org.springframework.data.gemfire.config.annotation.UsesGemFireProperties;
import org.springframework.data.gemfire.util.RuntimeExceptionFactory;
import org.springframework.util.Assert;

@Target(value={ElementType.TYPE})
@Retention(value=RetentionPolicy.RUNTIME)
@Inherited
@Documented
@Import(value={SslConfiguration.class})
@UsesGemFireProperties
public @interface EnableSsl {
    public String[] ciphers() default {"any"};

    public Component[] components() default {Component.ALL};

    public ComponentAlias[] componentCertificateAliases() default {};

    public String defaultCertificateAlias() default "";

    public boolean enableEndpointIdentification() default false;

    public String keystore() default "";

    public String keystorePassword() default "";

    public String keystoreType() default "JKS";

    public String[] protocols() default {"any"};

    public boolean requireAuthentication() default true;

    public String truststore() default "";

    public String truststorePassword() default "";

    public String truststoreType() default "JKS";

    public boolean useDefaultContext() default false;

    public boolean webRequireAuthentication() default false;

    public static @interface ComponentAlias {
        public String alias();

        public Component component();
    }

    public static enum Component {
        ALL("all"),
        CLUSTER("cluster"),
        GATEWAY("gateway"),
        JMX("jmx"),
        LOCATOR("locator"),
        SERVER("server"),
        WEB("web");

        private final String prefix;

        public static Component valueOfName(String name) {
            return Arrays.stream(Component.values()).filter(component -> component.name().equalsIgnoreCase(String.valueOf(name).trim())).findFirst().orElseThrow(() -> RuntimeExceptionFactory.newIllegalArgumentException("Name [%s] is not a valid component", name));
        }

        private Component(String prefix) {
            Assert.hasText((String)prefix, (String)"Prefix is required");
            this.prefix = prefix;
        }

        public String toString() {
            return this.prefix;
        }
    }
}

