/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.function.execution;

import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.geode.cache.execute.Execution;
import org.apache.geode.cache.execute.Function;
import org.apache.geode.cache.execute.FunctionException;
import org.apache.geode.cache.execute.ResultCollector;
import org.springframework.util.Assert;

abstract class AbstractFunctionExecution {
    private static final String NO_RESULT_MESSAGE = "Cannot return any result as the Function#hasResult() is false";
    private long timeout;
    private Function function;
    protected final Log logger = LogFactory.getLog(this.getClass());
    private Object[] args;
    private volatile ResultCollector<?, ?> resultCollector;
    private String functionId;

    public AbstractFunctionExecution(Function function, Object ... args) {
        Assert.notNull((Object)function, (String)"Function cannot be null");
        this.function = function;
        this.functionId = function.getId();
        this.args = args;
    }

    public AbstractFunctionExecution(String functionId, Object ... args) {
        Assert.hasText((String)functionId, (String)"Function ID must not be null or empty");
        this.functionId = functionId;
        this.args = args;
    }

    AbstractFunctionExecution() {
    }

    Object[] getArgs() {
        return this.args;
    }

    ResultCollector<?, ?> getCollector() {
        return this.resultCollector;
    }

    Function getFunction() {
        return this.function;
    }

    String getFunctionId() {
        return this.functionId;
    }

    long getTimeout() {
        return this.timeout;
    }

    <T> Iterable<T> execute() {
        return this.execute(true);
    }

    <T> Iterable<T> execute(Boolean returnResult) {
        ResultCollector resultCollector;
        Execution execution = this.getExecution();
        execution = execution.setArguments((Object)this.getArgs());
        execution = this.getCollector() != null ? execution.withCollector(this.getCollector()) : execution;
        Execution execution2 = execution = this.getKeys() != null ? execution.withFilter(this.getKeys()) : execution;
        if (this.isRegisteredFunction()) {
            resultCollector = execution.execute(this.functionId);
        } else {
            resultCollector = execution.execute(this.function);
            if (!this.function.hasResult()) {
                return null;
            }
        }
        if (!returnResult.booleanValue()) {
            return null;
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Using ResultsCollector " + resultCollector.getClass().getName()));
        }
        Iterable results = null;
        try {
            if (this.timeout > 0L) {
                try {
                    results = (Iterable)resultCollector.getResult(this.timeout, TimeUnit.MILLISECONDS);
                }
                catch (InterruptedException | FunctionException cause) {
                    throw new RuntimeException(cause);
                }
            } else {
                results = (Iterable)resultCollector.getResult();
            }
            return this.replaceSingletonNullCollectionWithEmptyList(results);
        }
        catch (FunctionException cause) {
            if (!cause.getMessage().equals(NO_RESULT_MESSAGE)) {
                throw cause;
            }
            return results;
        }
    }

    <T> T executeAndExtract() {
        Iterable<T> results = this.execute();
        if (results == null || !results.iterator().hasNext()) {
            return null;
        }
        T result = results.iterator().next();
        if (result instanceof Throwable) {
            throw new FunctionException(String.format("Execution of Function %s failed", this.function != null ? this.function.getClass().getName() : String.format("with ID [%s]", this.functionId)), (Throwable)result);
        }
        return result;
    }

    protected abstract Execution getExecution();

    protected AbstractFunctionExecution setArgs(Object ... args) {
        this.args = args;
        return this;
    }

    protected AbstractFunctionExecution setFunction(Function function) {
        this.function = function;
        return this;
    }

    protected AbstractFunctionExecution setFunctionId(String functionId) {
        this.functionId = functionId;
        return this;
    }

    protected AbstractFunctionExecution setResultCollector(ResultCollector<?, ?> resultCollector) {
        this.resultCollector = resultCollector;
        return this;
    }

    protected AbstractFunctionExecution setTimeout(long timeout) {
        this.timeout = timeout;
        return this;
    }

    protected Set<?> getKeys() {
        return null;
    }

    private boolean isRegisteredFunction() {
        return this.function == null;
    }

    private <T> Iterable<T> replaceSingletonNullCollectionWithEmptyList(Iterable<T> results) {
        if (results != null) {
            Iterator<T> it = results.iterator();
            if (!it.hasNext()) {
                return results;
            }
            if (it.next() == null && !it.hasNext()) {
                return Collections.emptyList();
            }
        }
        return results;
    }
}

