/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.function;

import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.geode.cache.execute.Function;
import org.apache.geode.cache.execute.FunctionService;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.CollectionUtils;

public class FunctionServiceFactoryBean
implements FactoryBean<FunctionService>,
InitializingBean {
    private static Log logger = LogFactory.getLog(FunctionServiceFactoryBean.class);
    private List<Function> functions;

    public void afterPropertiesSet() throws Exception {
        if (!CollectionUtils.isEmpty(this.functions)) {
            for (Function function : this.functions) {
                if (logger.isInfoEnabled()) {
                    logger.info((Object)String.format("registering Function with ID (%1$s)", function.getId()));
                }
                FunctionService.registerFunction((Function)function);
            }
        }
    }

    public void setFunctions(List<Function> functions) {
        this.functions = functions;
    }

    public FunctionService getObject() throws Exception {
        return null;
    }

    public Class<?> getObjectType() {
        return FunctionService.class;
    }

    public boolean isSingleton() {
        return true;
    }
}

