/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.config.annotation;

import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.data.annotation.Id;
import org.springframework.data.gemfire.GemfireUtils;
import org.springframework.data.gemfire.IndexFactoryBean;
import org.springframework.data.gemfire.IndexType;
import org.springframework.data.gemfire.config.annotation.EnableIndexing;
import org.springframework.data.gemfire.config.annotation.EntityDefinedRegionsConfiguration;
import org.springframework.data.gemfire.config.annotation.IndexConfigurer;
import org.springframework.data.gemfire.mapping.GemfirePersistentEntity;
import org.springframework.data.gemfire.mapping.GemfirePersistentProperty;
import org.springframework.data.gemfire.mapping.annotation.Indexed;
import org.springframework.data.gemfire.mapping.annotation.LuceneIndexed;
import org.springframework.data.gemfire.search.lucene.LuceneIndexFactoryBean;
import org.springframework.data.gemfire.util.CollectionUtils;
import org.springframework.data.gemfire.util.RuntimeExceptionFactory;
import org.springframework.util.StringUtils;

public class IndexConfiguration
extends EntityDefinedRegionsConfiguration {
    @Autowired(required=false)
    private List<IndexConfigurer> indexConfigurers = Collections.emptyList();

    protected Class<? extends Annotation> getEnableIndexingAnnotationType() {
        return EnableIndexing.class;
    }

    protected String getEnableIndexingAnnotationTypeName() {
        return this.getEnableIndexingAnnotationType().getName();
    }

    protected String getEnableIndexingAnnotationTypeSimpleName() {
        return this.getEnableIndexingAnnotationType().getSimpleName();
    }

    @Override
    protected GemfirePersistentEntity<?> postProcess(AnnotationMetadata importingClassMetadata, BeanDefinitionRegistry registry, GemfirePersistentEntity<?> persistentEntity) {
        GemfirePersistentEntity<?> localPersistentEntity = super.postProcess(importingClassMetadata, registry, persistentEntity);
        if (this.isAnnotationPresent(importingClassMetadata, this.getEnableIndexingAnnotationTypeName())) {
            AnnotationAttributes enableIndexingAttributes = this.getAnnotationAttributes(importingClassMetadata, this.getEnableIndexingAnnotationTypeName());
            localPersistentEntity.doWithProperties(persistentProperty -> {
                Optional<Annotation> idAnnotation = Optional.ofNullable(persistentProperty.findAnnotation(Id.class));
                idAnnotation.ifPresent(id -> this.registerIndexBeanDefinition(enableIndexingAttributes, localPersistentEntity, (GemfirePersistentProperty)persistentProperty, IndexType.KEY, (Annotation)id, registry));
                Optional<Annotation> indexedAnnotation = Optional.ofNullable(persistentProperty.findAnnotation(Indexed.class));
                indexedAnnotation.ifPresent(indexed -> this.registerIndexBeanDefinition(enableIndexingAttributes, localPersistentEntity, (GemfirePersistentProperty)persistentProperty, indexed.type(), (Annotation)indexed, registry));
                Optional<Annotation> luceneIndexedAnnotation = Optional.ofNullable(persistentProperty.findAnnotation(LuceneIndexed.class));
                luceneIndexedAnnotation.ifPresent(luceneIndexed -> this.registerLuceneIndexBeanDefinition(enableIndexingAttributes, localPersistentEntity, (GemfirePersistentProperty)persistentProperty, (Annotation)luceneIndexed, registry));
            });
        }
        return persistentEntity;
    }

    protected void registerIndexBeanDefinition(AnnotationAttributes enableIndexingAttributes, GemfirePersistentEntity<?> persistentEntity, GemfirePersistentProperty persistentProperty, IndexType indexType, Annotation indexAnnotation, BeanDefinitionRegistry registry) {
        Optional.ofNullable(indexAnnotation).ifPresent(localIndexAnnotation -> {
            AnnotationAttributes indexedAttributes = this.getAnnotationAttributes((Annotation)localIndexAnnotation);
            BeanDefinitionBuilder indexFactoryBeanBuilder = BeanDefinitionBuilder.genericBeanDefinition(IndexFactoryBean.class);
            String indexName = this.resolveName(persistentEntity, persistentProperty, indexedAttributes, indexType);
            indexFactoryBeanBuilder.addPropertyReference("cache", "gemfireCache");
            indexFactoryBeanBuilder.addPropertyValue("define", (Object)this.resolveDefine(enableIndexingAttributes));
            indexFactoryBeanBuilder.addPropertyValue("expression", (Object)this.resolveExpression(persistentEntity, persistentProperty, indexedAttributes));
            String from = this.resolveFrom(persistentEntity, persistentProperty, indexedAttributes);
            indexFactoryBeanBuilder.addPropertyValue("from", (Object)this.toRegionPath(from));
            indexFactoryBeanBuilder.addPropertyValue("ignoreIfExists", (Object)Boolean.TRUE);
            indexFactoryBeanBuilder.addPropertyValue("indexConfigurers", this.resolveIndexConfigurers());
            indexFactoryBeanBuilder.addPropertyValue("name", (Object)indexName);
            indexFactoryBeanBuilder.addPropertyValue("override", (Object)Boolean.FALSE);
            indexFactoryBeanBuilder.addPropertyValue("type", (Object)this.resolveType(persistentEntity, persistentProperty, indexedAttributes, indexType).toString());
            indexFactoryBeanBuilder.addDependsOn(this.toRegionName(from));
            registry.registerBeanDefinition(indexName, (BeanDefinition)indexFactoryBeanBuilder.getBeanDefinition());
        });
    }

    private String toRegionName(String from) {
        return Optional.ofNullable(from).filter(StringUtils::hasText).map(it -> {
            boolean isSubRegionPath = from.lastIndexOf("/") > 0;
            return !isSubRegionPath && from.startsWith("/") ? from.substring(1) : from;
        }).orElseThrow(() -> RuntimeExceptionFactory.newIllegalArgumentException("From clause [%s] is required", from));
    }

    private String toRegionPath(String from) {
        return Optional.ofNullable(from).filter(StringUtils::hasText).map(it -> from.startsWith("/") ? from : GemfireUtils.toRegionPath(from)).orElseThrow(() -> RuntimeExceptionFactory.newIllegalArgumentException("From clause [%s] is required", from));
    }

    protected void registerLuceneIndexBeanDefinition(AnnotationAttributes enableIndexingAttributes, GemfirePersistentEntity<?> persistentEntity, GemfirePersistentProperty persistentProperty, Annotation luceneIndexAnnotation, BeanDefinitionRegistry registry) {
        Optional.ofNullable(luceneIndexAnnotation).ifPresent(localLuceneIndexAnnotation -> {
            AnnotationAttributes luceneIndexAttributes = AnnotationAttributes.fromMap((Map)AnnotationUtils.getAnnotationAttributes((Annotation)localLuceneIndexAnnotation));
            BeanDefinitionBuilder luceneIndexFactoryBeanBuilder = BeanDefinitionBuilder.genericBeanDefinition(LuceneIndexFactoryBean.class);
            String indexName = luceneIndexAttributes.getString("name");
            boolean destroy = luceneIndexAttributes.containsKey((Object)"destroy") && luceneIndexAttributes.getBoolean("destroy");
            luceneIndexFactoryBeanBuilder.addPropertyReference("cache", "gemfireCache");
            luceneIndexFactoryBeanBuilder.addPropertyValue("destroy", (Object)destroy);
            luceneIndexFactoryBeanBuilder.addPropertyValue("fields", (Object)persistentProperty.getName());
            luceneIndexFactoryBeanBuilder.addPropertyValue("indexConfigurers", this.resolveIndexConfigurers());
            luceneIndexFactoryBeanBuilder.addPropertyValue("indexName", (Object)indexName);
            luceneIndexFactoryBeanBuilder.addPropertyValue("regionPath", (Object)persistentEntity.getRegionName());
            registry.registerBeanDefinition(indexName, (BeanDefinition)luceneIndexFactoryBeanBuilder.getBeanDefinition());
        });
    }

    private List<IndexConfigurer> resolveIndexConfigurers() {
        return Optional.ofNullable(this.indexConfigurers).filter(indexConfigurers -> !indexConfigurers.isEmpty()).orElseGet(() -> Optional.of(this.getBeanFactory()).filter(beanFactory -> beanFactory instanceof ListableBeanFactory).map(beanFactory -> {
            Map beansOfType = ((ListableBeanFactory)beanFactory).getBeansOfType(IndexConfigurer.class, true, false);
            return CollectionUtils.nullSafeMap(beansOfType).values().stream().collect(Collectors.toList());
        }).orElseGet(Collections::emptyList));
    }

    private boolean resolveDefine(AnnotationAttributes enableIndexingAttributes) {
        return enableIndexingAttributes.containsKey((Object)"define") && enableIndexingAttributes.getBoolean("define");
    }

    private String resolveExpression(GemfirePersistentEntity<?> persistentEntity, GemfirePersistentProperty persistentProperty, AnnotationAttributes indexedAttributes) {
        String expression = indexedAttributes.containsKey((Object)"expression") ? indexedAttributes.getString("expression") : null;
        return StringUtils.hasText((String)expression) ? expression : persistentProperty.getName();
    }

    private String resolveFrom(GemfirePersistentEntity<?> persistentEntity, GemfirePersistentProperty persistentProperty, AnnotationAttributes indexedAttributes) {
        String from = indexedAttributes.containsKey((Object)"from") ? indexedAttributes.getString("from") : null;
        return StringUtils.hasText((String)from) ? from : persistentEntity.getRegionName();
    }

    private String resolveName(GemfirePersistentEntity<?> persistentEntity, GemfirePersistentProperty persistentProperty, AnnotationAttributes indexedAttributes, IndexType indexType) {
        String indexName = indexedAttributes.containsKey((Object)"name") ? indexedAttributes.getString("name") : null;
        return StringUtils.hasText((String)indexName) ? indexName : this.generateIndexName(persistentEntity, persistentProperty, indexType);
    }

    private String generateIndexName(GemfirePersistentEntity persistentEntity, GemfirePersistentProperty persistentProperty, IndexType indexType) {
        return String.format("%1$s%2$s%3$sIdx", persistentEntity.getRegionName(), StringUtils.capitalize((String)persistentProperty.getName()), StringUtils.capitalize((String)indexType.name().toLowerCase()));
    }

    private IndexType resolveType(GemfirePersistentEntity<?> persistentEntity, GemfirePersistentProperty persistentProperty, AnnotationAttributes indexedAttributes, IndexType indexType) {
        IndexType resolvedIndexType = indexedAttributes.containsKey((Object)"type") ? (IndexType)indexedAttributes.getEnum("type") : null;
        return Optional.ofNullable(resolvedIndexType).orElse(indexType);
    }
}

