/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.config.annotation;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Inherited;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.data.gemfire.config.annotation.CacheServerConfiguration;
import org.springframework.data.gemfire.server.SubscriptionEvictionPolicy;

@Target(value={ElementType.TYPE})
@Retention(value=RetentionPolicy.RUNTIME)
@Inherited
@Documented
@Configuration
@Import(value={CacheServerConfiguration.class})
public @interface CacheServerApplication {
    public boolean autoStartup() default true;

    public String bindAddress() default "";

    public boolean copyOnRead() default false;

    public float criticalHeapPercentage() default 0.0f;

    public float criticalOffHeapPercentage() default 0.0f;

    public boolean enableAutoReconnect() default false;

    public float evictionHeapPercentage() default 0.0f;

    public float evictionOffHeapPercentage() default 0.0f;

    public String hostnameForClients() default "";

    public long loadPollInterval() default 5000L;

    public String locators() default "";

    public int lockLease() default 120;

    public int lockTimeout() default 60;

    public String logLevel() default "config";

    public int maxConnections() default 800;

    public int maxMessageCount() default 230000;

    public int maxThreads() default 0;

    public int maxTimeBetweenPings() default 60000;

    public int messageSyncInterval() default 1;

    public int messageTimeToLive() default 180;

    public String name() default "SpringBasedCacheServerApplication";

    public int port() default 40404;

    public int searchTimeout() default 300;

    public int socketBufferSize() default 32768;

    public int subscriptionCapacity() default 1;

    public String subscriptionDiskStoreName() default "";

    public SubscriptionEvictionPolicy subscriptionEvictionPolicy() default SubscriptionEvictionPolicy.NONE;

    public boolean useBeanFactoryLocator() default false;

    public boolean useClusterConfiguration() default false;

    public boolean tcpNoDelay() default true;
}

