/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.wan;

import java.util.List;
import java.util.Optional;
import org.apache.geode.cache.Cache;
import org.apache.geode.cache.wan.GatewayEventFilter;
import org.apache.geode.cache.wan.GatewayEventSubstitutionFilter;
import org.apache.geode.cache.wan.GatewaySender;
import org.apache.geode.cache.wan.GatewaySenderFactory;
import org.apache.geode.cache.wan.GatewayTransportFilter;
import org.apache.shiro.util.StringUtils;
import org.springframework.data.gemfire.util.CollectionUtils;
import org.springframework.data.gemfire.wan.AbstractWANComponentFactoryBean;
import org.springframework.data.gemfire.wan.GatewaySenderWrapper;

public class GatewaySenderFactoryBean
extends AbstractWANComponentFactoryBean<GatewaySender> {
    private boolean manualStart = false;
    private int remoteDistributedSystemId;
    private GatewaySender gatewaySender;
    private List<GatewayEventFilter> eventFilters;
    private List<GatewayTransportFilter> transportFilters;
    private Boolean diskSynchronous;
    private Boolean batchConflationEnabled;
    private Boolean parallel;
    private Boolean persistent;
    private GatewaySender.OrderPolicy orderPolicy;
    private GatewayEventSubstitutionFilter eventSubstitutionFilter;
    private Integer alertThreshold;
    private Integer batchSize;
    private Integer batchTimeInterval;
    private Integer dispatcherThreads;
    private Integer maximumQueueMemory;
    private Integer socketBufferSize;
    private Integer socketReadTimeout;
    private String diskStoreReference;

    public GatewaySenderFactoryBean(Cache cache) {
        super(cache);
    }

    @Override
    protected void doInit() {
        GatewaySenderFactory gatewaySenderFactory = this.resolveGatewaySenderFactory();
        Optional.ofNullable(this.alertThreshold).ifPresent(arg_0 -> ((GatewaySenderFactory)gatewaySenderFactory).setAlertThreshold(arg_0));
        Optional.ofNullable(this.batchConflationEnabled).ifPresent(arg_0 -> ((GatewaySenderFactory)gatewaySenderFactory).setBatchConflationEnabled(arg_0));
        Optional.ofNullable(this.batchSize).ifPresent(arg_0 -> ((GatewaySenderFactory)gatewaySenderFactory).setBatchSize(arg_0));
        Optional.ofNullable(this.batchTimeInterval).ifPresent(arg_0 -> ((GatewaySenderFactory)gatewaySenderFactory).setBatchTimeInterval(arg_0));
        Optional.ofNullable(this.diskStoreReference).filter(StringUtils::hasText).ifPresent(arg_0 -> ((GatewaySenderFactory)gatewaySenderFactory).setDiskStoreName(arg_0));
        Optional.ofNullable(this.diskSynchronous).ifPresent(arg_0 -> ((GatewaySenderFactory)gatewaySenderFactory).setDiskSynchronous(arg_0));
        Optional.ofNullable(this.dispatcherThreads).ifPresent(arg_0 -> ((GatewaySenderFactory)gatewaySenderFactory).setDispatcherThreads(arg_0));
        CollectionUtils.nullSafeList(this.eventFilters).forEach(arg_0 -> ((GatewaySenderFactory)gatewaySenderFactory).addGatewayEventFilter(arg_0));
        Optional.ofNullable(this.eventSubstitutionFilter).ifPresent(arg_0 -> ((GatewaySenderFactory)gatewaySenderFactory).setGatewayEventSubstitutionFilter(arg_0));
        gatewaySenderFactory.setManualStart(this.manualStart);
        Optional.ofNullable(this.maximumQueueMemory).ifPresent(arg_0 -> ((GatewaySenderFactory)gatewaySenderFactory).setMaximumQueueMemory(arg_0));
        Optional.ofNullable(this.orderPolicy).ifPresent(arg_0 -> ((GatewaySenderFactory)gatewaySenderFactory).setOrderPolicy(arg_0));
        gatewaySenderFactory.setParallel(this.isParallelGatewaySender());
        gatewaySenderFactory.setPersistenceEnabled(this.isPersistent());
        Optional.ofNullable(this.socketBufferSize).ifPresent(arg_0 -> ((GatewaySenderFactory)gatewaySenderFactory).setSocketBufferSize(arg_0));
        Optional.ofNullable(this.socketReadTimeout).ifPresent(arg_0 -> ((GatewaySenderFactory)gatewaySenderFactory).setSocketReadTimeout(arg_0));
        CollectionUtils.nullSafeList(this.transportFilters).forEach(arg_0 -> ((GatewaySenderFactory)gatewaySenderFactory).addGatewayTransportFilter(arg_0));
        GatewaySenderWrapper wrapper = new GatewaySenderWrapper(gatewaySenderFactory.create(this.getName(), this.remoteDistributedSystemId));
        wrapper.setManualStart(this.manualStart);
        this.gatewaySender = wrapper;
    }

    private GatewaySenderFactory resolveGatewaySenderFactory() {
        return this.factory != null ? (GatewaySenderFactory)this.factory : this.cache.createGatewaySenderFactory();
    }

    public GatewaySender getObject() throws Exception {
        return this.gatewaySender;
    }

    public Class<?> getObjectType() {
        return this.gatewaySender != null ? this.gatewaySender.getClass() : GatewaySender.class;
    }

    public void setAlertThreshold(Integer alertThreshold) {
        this.alertThreshold = alertThreshold;
    }

    public void setBatchConflationEnabled(Boolean batchConflationEnabled) {
        this.batchConflationEnabled = batchConflationEnabled;
    }

    public void setBatchSize(Integer batchSize) {
        this.batchSize = batchSize;
    }

    public void setBatchTimeInterval(Integer batchTimeInterval) {
        this.batchTimeInterval = batchTimeInterval;
    }

    public void setDiskStoreRef(String diskStoreRef) {
        this.diskStoreReference = diskStoreRef;
    }

    public void setDiskSynchronous(Boolean diskSynchronous) {
        this.diskSynchronous = diskSynchronous;
    }

    public void setDispatcherThreads(Integer dispatcherThreads) {
        this.dispatcherThreads = dispatcherThreads;
    }

    public void setEventFilters(List<GatewayEventFilter> gatewayEventFilters) {
        this.eventFilters = gatewayEventFilters;
    }

    public void setEventSubstitutionFilter(GatewayEventSubstitutionFilter eventSubstitutionFilter) {
        this.eventSubstitutionFilter = eventSubstitutionFilter;
    }

    public void setManualStart(Boolean manualStart) {
        this.manualStart = Boolean.TRUE.equals(manualStart);
    }

    public void setMaximumQueueMemory(Integer maximumQueueMemory) {
        this.maximumQueueMemory = maximumQueueMemory;
    }

    public void setOrderPolicy(GatewaySender.OrderPolicy orderPolicy) {
        this.orderPolicy = orderPolicy;
    }

    public void setParallel(Boolean parallel) {
        this.parallel = parallel;
    }

    public boolean isSerialGatewaySender() {
        return !this.isParallelGatewaySender();
    }

    public boolean isParallelGatewaySender() {
        return Boolean.TRUE.equals(this.parallel);
    }

    public void setPersistent(Boolean persistent) {
        this.persistent = persistent;
    }

    public boolean isNotPersistent() {
        return !this.isPersistent();
    }

    public boolean isPersistent() {
        return Boolean.TRUE.equals(this.persistent);
    }

    public void setRemoteDistributedSystemId(int remoteDistributedSystemId) {
        this.remoteDistributedSystemId = remoteDistributedSystemId;
    }

    public void setSocketBufferSize(Integer socketBufferSize) {
        this.socketBufferSize = socketBufferSize;
    }

    public void setSocketReadTimeout(Integer socketReadTimeout) {
        this.socketReadTimeout = socketReadTimeout;
    }

    public void setTransportFilters(List<GatewayTransportFilter> gatewayTransportFilters) {
        this.transportFilters = gatewayTransportFilters;
    }
}

