/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.config.annotation.support;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.core.OrderComparator;
import org.springframework.data.gemfire.config.annotation.support.Configurer;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;

public abstract class AbstractLazyResolvingComposableConfigurer<T, C extends Configurer<T>>
implements BeanFactoryAware,
Configurer<T> {
    private BeanFactory beanFactory;
    private List<C> configurers = Collections.emptyList();

    public void setBeanFactory(@Nullable BeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
    }

    protected Optional<BeanFactory> getBeanFactory() {
        return Optional.ofNullable(this.beanFactory);
    }

    @NonNull
    protected abstract Class<C> getConfigurerType();

    @NonNull
    protected Stream<C> resolveConfigurers() {
        return Optional.ofNullable(this.configurers).filter(it -> !it.isEmpty()).orElseGet(() -> this.getBeanFactory().filter(ListableBeanFactory.class::isInstance).map(ListableBeanFactory.class::cast).map(beanFactory -> {
            Map beansOfType = beanFactory.getBeansOfType(this.getConfigurerType(), true, false);
            this.configurers = beansOfType.values().stream().sorted(new OrderComparator()).collect(Collectors.toList());
            return this.configurers;
        }).orElseGet(Collections::emptyList)).stream();
    }

    @Override
    public synchronized void configure(String beanName, T bean) {
        this.resolveConfigurers().forEach(configurer -> configurer.configure(beanName, bean));
    }

    public <S extends AbstractLazyResolvingComposableConfigurer<T, C>> S with(@Nullable BeanFactory beanFactory) {
        this.setBeanFactory(beanFactory);
        return (S)this;
    }
}

