/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire;

import org.apache.geode.CancelException;
import org.apache.geode.CopyException;
import org.apache.geode.GemFireCacheException;
import org.apache.geode.GemFireCheckedException;
import org.apache.geode.GemFireConfigException;
import org.apache.geode.GemFireException;
import org.apache.geode.GemFireIOException;
import org.apache.geode.IncompatibleSystemException;
import org.apache.geode.InternalGemFireException;
import org.apache.geode.InvalidValueException;
import org.apache.geode.NoSystemException;
import org.apache.geode.SystemConnectException;
import org.apache.geode.SystemIsRunningException;
import org.apache.geode.UnmodifiableException;
import org.apache.geode.admin.AdminException;
import org.apache.geode.admin.RegionNotFoundException;
import org.apache.geode.admin.RuntimeAdminException;
import org.apache.geode.cache.CacheException;
import org.apache.geode.cache.CacheExistsException;
import org.apache.geode.cache.CacheLoaderException;
import org.apache.geode.cache.CacheRuntimeException;
import org.apache.geode.cache.CacheWriterException;
import org.apache.geode.cache.CacheXmlException;
import org.apache.geode.cache.CommitConflictException;
import org.apache.geode.cache.CommitIncompleteException;
import org.apache.geode.cache.DiskAccessException;
import org.apache.geode.cache.EntryDestroyedException;
import org.apache.geode.cache.EntryExistsException;
import org.apache.geode.cache.EntryNotFoundException;
import org.apache.geode.cache.FailedSynchronizationException;
import org.apache.geode.cache.OperationAbortedException;
import org.apache.geode.cache.PartitionedRegionDistributionException;
import org.apache.geode.cache.PartitionedRegionStorageException;
import org.apache.geode.cache.RegionDestroyedException;
import org.apache.geode.cache.RegionExistsException;
import org.apache.geode.cache.ResourceException;
import org.apache.geode.cache.RoleException;
import org.apache.geode.cache.StatisticsDisabledException;
import org.apache.geode.cache.SynchronizationCommitConflictException;
import org.apache.geode.cache.VersionException;
import org.apache.geode.cache.client.ServerConnectivityException;
import org.apache.geode.cache.execute.FunctionException;
import org.apache.geode.cache.query.CqClosedException;
import org.apache.geode.cache.query.IndexInvalidException;
import org.apache.geode.cache.query.IndexMaintenanceException;
import org.apache.geode.cache.query.QueryException;
import org.apache.geode.cache.query.QueryExecutionTimeoutException;
import org.apache.geode.cache.query.QueryInvalidException;
import org.apache.geode.distributed.LeaseExpiredException;
import org.apache.geode.security.GemFireSecurityException;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.DataAccessResourceFailureException;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.dao.DataRetrievalFailureException;
import org.springframework.dao.DuplicateKeyException;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.dao.InvalidDataAccessResourceUsageException;
import org.springframework.dao.PermissionDeniedDataAccessException;
import org.springframework.dao.PessimisticLockingFailureException;
import org.springframework.dao.TypeMismatchDataAccessException;
import org.springframework.data.gemfire.GemfireCancellationException;
import org.springframework.data.gemfire.GemfireIndexException;
import org.springframework.data.gemfire.GemfireQueryException;
import org.springframework.data.gemfire.GemfireSystemException;
import org.springframework.util.ClassUtils;

public abstract class GemfireCacheUtils {
    private static Class<?> CQ_EXCEPTION_CLASS;

    public static DataAccessException convertGemfireAccessException(GemFireException ex) {
        if (ex instanceof CacheException) {
            if (ex instanceof CacheExistsException) {
                return new DataIntegrityViolationException(ex.getMessage(), (Throwable)ex);
            }
            if (ex instanceof CommitConflictException) {
                return new DataIntegrityViolationException(ex.getMessage(), (Throwable)ex);
            }
            if (ex instanceof CommitIncompleteException) {
                return new DataIntegrityViolationException(ex.getMessage(), (Throwable)ex);
            }
            if (ex instanceof EntryExistsException) {
                return new DuplicateKeyException(ex.getMessage(), (Throwable)ex);
            }
            if (ex instanceof EntryNotFoundException) {
                return new DataRetrievalFailureException(ex.getMessage(), (Throwable)ex);
            }
            if (ex instanceof RegionExistsException) {
                return new DataIntegrityViolationException(ex.getMessage(), (Throwable)ex);
            }
        }
        if (ex instanceof CacheRuntimeException) {
            if (ex instanceof CacheXmlException) {
                return new GemfireSystemException(ex);
            }
            if (ex instanceof CancelException) {
                return new GemfireCancellationException((CancelException)ex);
            }
            if (ex instanceof CqClosedException) {
                return new InvalidDataAccessApiUsageException(ex.getMessage(), (Throwable)ex);
            }
            if (ex instanceof DiskAccessException) {
                return new DataAccessResourceFailureException(ex.getMessage(), (Throwable)ex);
            }
            if (ex instanceof EntryDestroyedException) {
                return new InvalidDataAccessApiUsageException(ex.getMessage(), (Throwable)ex);
            }
            if (ex instanceof FailedSynchronizationException) {
                return new PessimisticLockingFailureException(ex.getMessage(), (Throwable)ex);
            }
            if (ex instanceof IndexMaintenanceException) {
                return new GemfireIndexException((IndexMaintenanceException)ex);
            }
            if (ex instanceof OperationAbortedException) {
                if (ex instanceof CacheLoaderException) {
                    return new GemfireSystemException(ex);
                }
                if (ex instanceof CacheWriterException) {
                    return new GemfireSystemException(ex);
                }
                return new DataAccessResourceFailureException(ex.getMessage(), (Throwable)ex);
            }
            if (ex instanceof PartitionedRegionDistributionException) {
                return new DataAccessResourceFailureException(ex.getMessage(), (Throwable)ex);
            }
            if (ex instanceof PartitionedRegionStorageException) {
                return new DataAccessResourceFailureException(ex.getMessage(), (Throwable)ex);
            }
            if (ex instanceof QueryExecutionTimeoutException) {
                return new GemfireQueryException((QueryExecutionTimeoutException)ex);
            }
            if (ex instanceof RegionDestroyedException) {
                return new InvalidDataAccessResourceUsageException(ex.getMessage(), (Throwable)ex);
            }
            if (ex instanceof RegionNotFoundException) {
                return new InvalidDataAccessResourceUsageException(ex.getMessage(), (Throwable)ex);
            }
            if (ex instanceof ResourceException) {
                return new DataAccessResourceFailureException(ex.getMessage(), (Throwable)ex);
            }
            if (ex instanceof RoleException) {
                return new GemfireSystemException(ex);
            }
            if (ex instanceof StatisticsDisabledException) {
                return new GemfireSystemException(ex);
            }
            if (ex instanceof SynchronizationCommitConflictException) {
                return new PessimisticLockingFailureException(ex.getMessage(), (Throwable)ex);
            }
        }
        if (ex instanceof CopyException) {
            return new GemfireSystemException(ex);
        }
        if (ex instanceof FunctionException) {
            return new InvalidDataAccessApiUsageException(ex.getMessage(), (Throwable)ex);
        }
        if (ex instanceof GemFireCacheException) {
            return GemfireCacheUtils.convertGemfireAccessException((GemFireException)((GemFireCacheException)ex).getCacheException());
        }
        if (ex instanceof GemFireConfigException) {
            return new GemfireSystemException(ex);
        }
        if (ex instanceof GemFireIOException) {
            return new DataAccessResourceFailureException(ex.getMessage(), (Throwable)ex);
        }
        if (ex instanceof GemFireSecurityException) {
            return new PermissionDeniedDataAccessException(ex.getMessage(), (Throwable)ex);
        }
        if (ex instanceof IncompatibleSystemException) {
            return new GemfireSystemException(ex);
        }
        if (ex instanceof InternalGemFireException) {
            return new GemfireSystemException(ex);
        }
        if (ex instanceof InvalidValueException) {
            return new TypeMismatchDataAccessException(ex.getMessage(), (Throwable)ex);
        }
        if (ex instanceof LeaseExpiredException) {
            return new PessimisticLockingFailureException(ex.getMessage(), (Throwable)ex);
        }
        if (ex instanceof NoSystemException) {
            return new GemfireSystemException(ex);
        }
        if (ex instanceof RuntimeAdminException) {
            return new GemfireSystemException(ex);
        }
        if (ex instanceof ServerConnectivityException) {
            return new DataAccessResourceFailureException(ex.getMessage(), (Throwable)ex);
        }
        if (ex instanceof SystemConnectException) {
            return new DataAccessResourceFailureException(ex.getMessage(), (Throwable)ex);
        }
        if (ex instanceof SystemIsRunningException) {
            return new GemfireSystemException(ex);
        }
        if (ex instanceof UnmodifiableException) {
            return new GemfireSystemException(ex);
        }
        DataAccessException dae = GemfireCacheUtils.convertQueryExceptions((RuntimeException)((Object)ex));
        if (dae != null) {
            return dae;
        }
        return new GemfireSystemException(ex);
    }

    static DataAccessException convertQueryExceptions(RuntimeException ex) {
        if (ex instanceof IndexInvalidException) {
            return GemfireCacheUtils.convertGemfireAccessException((IndexInvalidException)((Object)ex));
        }
        if (ex instanceof QueryInvalidException) {
            return GemfireCacheUtils.convertGemfireAccessException((QueryInvalidException)((Object)ex));
        }
        if (GemfireCacheUtils.isCqInvalidException(ex)) {
            return GemfireCacheUtils.convertCqInvalidException(ex);
        }
        return new GemfireSystemException(ex);
    }

    public static DataAccessException convertGemfireAccessException(GemFireCheckedException ex) {
        if (ex instanceof QueryException) {
            return new GemfireQueryException((QueryException)((Object)ex));
        }
        if (ex instanceof VersionException) {
            return new DataAccessResourceFailureException(ex.getMessage(), (Throwable)ex);
        }
        if (ex instanceof AdminException) {
            return new GemfireSystemException(ex);
        }
        return new GemfireSystemException(ex);
    }

    public static DataAccessException convertGemfireAccessException(IndexInvalidException ex) {
        return new GemfireIndexException(ex);
    }

    public static DataAccessException convertGemfireAccessException(QueryInvalidException ex) {
        return new GemfireQueryException(ex);
    }

    static boolean isCqInvalidException(RuntimeException ex) {
        return CQ_EXCEPTION_CLASS != null && CQ_EXCEPTION_CLASS.isAssignableFrom(ex.getClass());
    }

    static DataAccessException convertCqInvalidException(RuntimeException ex) {
        return new GemfireQueryException(ex);
    }

    static {
        Class type = null;
        try {
            type = ClassUtils.resolveClassName((String)"org.apache.geode.cache.query.CqInvalidException", (ClassLoader)GemfireCacheUtils.class.getClassLoader());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        CQ_EXCEPTION_CLASS = type;
    }
}

