/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.elasticsearch.repository.query;

import org.reactivestreams.Publisher;
import org.springframework.core.convert.converter.Converter;
import org.springframework.data.elasticsearch.core.ReactiveElasticsearchOperations;
import org.springframework.data.elasticsearch.core.SearchHit;
import org.springframework.data.elasticsearch.core.SearchHitSupport;
import org.springframework.data.elasticsearch.core.mapping.ElasticsearchPersistentEntity;
import org.springframework.data.elasticsearch.core.mapping.ElasticsearchPersistentProperty;
import org.springframework.data.elasticsearch.core.mapping.IndexCoordinates;
import org.springframework.data.elasticsearch.core.query.BaseQuery;
import org.springframework.data.elasticsearch.core.query.ByQueryResponse;
import org.springframework.data.elasticsearch.core.query.DeleteQuery;
import org.springframework.data.elasticsearch.core.query.Query;
import org.springframework.data.elasticsearch.repository.query.ElasticsearchParameterAccessor;
import org.springframework.data.elasticsearch.repository.query.ElasticsearchParametersParameterAccessor;
import org.springframework.data.elasticsearch.repository.query.ReactiveElasticsearchParametersParameterAccessor;
import org.springframework.data.elasticsearch.repository.query.ReactiveElasticsearchQueryExecution;
import org.springframework.data.elasticsearch.repository.query.ReactiveElasticsearchQueryMethod;
import org.springframework.data.expression.ValueEvaluationContextProvider;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.repository.query.ParameterAccessor;
import org.springframework.data.repository.query.QueryMethod;
import org.springframework.data.repository.query.RepositoryQuery;
import org.springframework.data.repository.query.ResultProcessor;
import org.springframework.data.repository.query.ReturnedType;
import org.springframework.util.Assert;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

abstract class AbstractReactiveElasticsearchRepositoryQuery
implements RepositoryQuery {
    protected final ReactiveElasticsearchQueryMethod queryMethod;
    private final ReactiveElasticsearchOperations elasticsearchOperations;
    protected final ValueEvaluationContextProvider evaluationContextProvider;

    AbstractReactiveElasticsearchRepositoryQuery(ReactiveElasticsearchQueryMethod queryMethod, ReactiveElasticsearchOperations elasticsearchOperations, ValueEvaluationContextProvider evaluationContextProvider) {
        Assert.notNull((Object)((Object)queryMethod), (String)"queryMethod must not be null");
        Assert.notNull((Object)elasticsearchOperations, (String)"elasticsearchOperations must not be null");
        Assert.notNull((Object)evaluationContextProvider, (String)"evaluationContextProvider must not be null");
        this.queryMethod = queryMethod;
        this.elasticsearchOperations = elasticsearchOperations;
        this.evaluationContextProvider = evaluationContextProvider;
    }

    public Object execute(Object[] parameters) {
        Object result = this.queryMethod.hasReactiveWrapperParameter() ? this.executeDeferred(parameters) : this.execute(new ReactiveElasticsearchParametersParameterAccessor(this.queryMethod, parameters));
        return this.queryMethod.isNotSearchHitMethod() ? SearchHitSupport.unwrapSearchHits(result) : result;
    }

    private Object executeDeferred(Object[] parameters) {
        ReactiveElasticsearchParametersParameterAccessor parameterAccessor = new ReactiveElasticsearchParametersParameterAccessor(this.queryMethod, parameters);
        if (this.getQueryMethod().isCollectionQuery()) {
            return Flux.defer(() -> (Publisher)this.execute(parameterAccessor));
        }
        return Mono.defer(() -> (Mono)this.execute(parameterAccessor));
    }

    private Object execute(ElasticsearchParametersParameterAccessor parameterAccessor) {
        ResultProcessor processor = this.queryMethod.getResultProcessor().withDynamicProjection((ParameterAccessor)parameterAccessor);
        ReturnedType returnedType = processor.getReturnedType();
        Class domainType = returnedType.getDomainType();
        Class typeToRead = returnedType.getTypeToRead();
        if (SearchHit.class.isAssignableFrom(typeToRead)) {
            typeToRead = this.queryMethod.unwrappedReturnType;
        }
        BaseQuery query = this.createQuery(parameterAccessor);
        Assert.notNull((Object)query, (String)"unsupported query");
        this.queryMethod.addSpecialMethodParameters(query, parameterAccessor, this.elasticsearchOperations.getElasticsearchConverter(), this.evaluationContextProvider);
        String indexName = this.queryMethod.getEntityInformation().getIndexName();
        IndexCoordinates index = IndexCoordinates.of(indexName);
        ReactiveElasticsearchQueryExecution execution = this.getExecution(parameterAccessor, new ReactiveElasticsearchQueryExecution.ResultProcessingConverter(processor));
        return execution.execute(query, domainType, typeToRead, index);
    }

    protected abstract BaseQuery createQuery(ElasticsearchParametersParameterAccessor var1);

    private ReactiveElasticsearchQueryExecution getExecution(ElasticsearchParameterAccessor accessor, Converter<Object, Object> resultProcessing) {
        return new ReactiveElasticsearchQueryExecution.ResultProcessingExecution(this.getExecutionToWrap(accessor, this.elasticsearchOperations), resultProcessing);
    }

    private ReactiveElasticsearchQueryExecution getExecutionToWrap(ElasticsearchParameterAccessor accessor, ReactiveElasticsearchOperations operations) {
        if (this.isDeleteQuery()) {
            return (query, type, targetType, indexCoordinates) -> operations.delete(DeleteQuery.builder(query).build(), type, indexCoordinates).map(ByQueryResponse::getDeleted);
        }
        if (this.isCountQuery()) {
            return (query, type, targetType, indexCoordinates) -> operations.count(query, type, indexCoordinates);
        }
        if (this.isExistsQuery()) {
            return (query, type, targetType, indexCoordinates) -> operations.count(query, type, indexCoordinates).map(count -> count > 0L);
        }
        if (this.queryMethod.isCollectionQuery()) {
            return (query, type, targetType, indexCoordinates) -> operations.search((Query)query.setPageable(accessor.getPageable()), type, targetType, indexCoordinates);
        }
        return operations::search;
    }

    abstract boolean isDeleteQuery();

    abstract boolean isCountQuery();

    abstract boolean isExistsQuery();

    abstract boolean isLimiting();

    public QueryMethod getQueryMethod() {
        return this.queryMethod;
    }

    protected ReactiveElasticsearchOperations getElasticsearchOperations() {
        return this.elasticsearchOperations;
    }

    protected MappingContext<? extends ElasticsearchPersistentEntity<?>, ElasticsearchPersistentProperty> getMappingContext() {
        return this.elasticsearchOperations.getElasticsearchConverter().getMappingContext();
    }
}

