/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.elasticsearch.core.suggest.response;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.lang.Nullable;

public class Suggest {
    private final List<Suggestion<? extends Suggestion.Entry<? extends Suggestion.Entry.Option>>> suggestions;
    private final Map<String, Suggestion<? extends Suggestion.Entry<? extends Suggestion.Entry.Option>>> suggestionsMap;
    private final boolean hasScoreDocs;

    public Suggest(List<Suggestion<? extends Suggestion.Entry<? extends Suggestion.Entry.Option>>> suggestions, boolean hasScoreDocs) {
        this.suggestions = suggestions;
        this.suggestionsMap = new HashMap<String, Suggestion<? extends Suggestion.Entry<? extends Suggestion.Entry.Option>>>();
        suggestions.forEach(suggestion -> this.suggestionsMap.put(suggestion.getName(), (Suggestion<? extends Suggestion.Entry<? extends Suggestion.Entry.Option>>)suggestion));
        this.hasScoreDocs = hasScoreDocs;
    }

    public List<Suggestion<? extends Suggestion.Entry<? extends Suggestion.Entry.Option>>> getSuggestions() {
        return this.suggestions;
    }

    public Suggestion<? extends Suggestion.Entry<? extends Suggestion.Entry.Option>> getSuggestion(String name) {
        return this.suggestionsMap.get(name);
    }

    public boolean hasScoreDocs() {
        return this.hasScoreDocs;
    }

    public static abstract class Suggestion<E extends Entry<? extends Entry.Option>> {
        private final String name;
        private final int size;
        private final List<E> entries;

        public Suggestion(String name, int size, List<E> entries) {
            this.name = name;
            this.size = size;
            this.entries = entries;
        }

        public String getName() {
            return this.name;
        }

        public int getSize() {
            return this.size;
        }

        public List<E> getEntries() {
            return this.entries;
        }

        public static abstract class Entry<O extends Option> {
            private final String text;
            private final int offset;
            private final int length;
            private final List<O> options;

            public Entry(String text, int offset, int length, List<O> options) {
                this.text = text;
                this.offset = offset;
                this.length = length;
                this.options = options;
            }

            public String getText() {
                return this.text;
            }

            public int getOffset() {
                return this.offset;
            }

            public int getLength() {
                return this.length;
            }

            public List<O> getOptions() {
                return this.options;
            }

            public static abstract class Option {
                private final String text;
                @Nullable
                private final String highlighted;
                @Nullable
                private final Double score;
                @Nullable
                private final Boolean collateMatch;

                public Option(String text, @Nullable String highlighted, @Nullable Double score, @Nullable Boolean collateMatch) {
                    this.text = text;
                    this.highlighted = highlighted;
                    this.score = score;
                    this.collateMatch = collateMatch;
                }

                public String getText() {
                    return this.text;
                }

                @Nullable
                public String getHighlighted() {
                    return this.highlighted;
                }

                @Nullable
                public Double getScore() {
                    return this.score;
                }

                @Nullable
                public Boolean getCollateMatch() {
                    return this.collateMatch;
                }
            }
        }
    }
}

