/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.elasticsearch.core.mapping;

import java.util.Objects;
import org.springframework.data.elasticsearch.core.query.Query;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class Alias {
    private final String alias;
    @Nullable
    private final Query filter;
    @Nullable
    private final String indexRouting;
    @Nullable
    private final String searchRouting;
    @Nullable
    private final String routing;
    @Nullable
    private final Boolean isHidden;
    @Nullable
    private final Boolean isWriteIndex;

    private Alias(Builder builder) {
        this.alias = builder.alias;
        this.filter = builder.filter;
        this.indexRouting = builder.indexRouting;
        this.searchRouting = builder.searchRouting;
        this.routing = builder.routing;
        this.isHidden = builder.isHidden;
        this.isWriteIndex = builder.isWriteIndex;
    }

    public String getAlias() {
        return this.alias;
    }

    @Nullable
    public Query getFilter() {
        return this.filter;
    }

    @Nullable
    public String getIndexRouting() {
        return this.indexRouting;
    }

    @Nullable
    public String getSearchRouting() {
        return this.searchRouting;
    }

    @Nullable
    public String getRouting() {
        return this.routing;
    }

    @Nullable
    public Boolean getHidden() {
        return this.isHidden;
    }

    @Nullable
    public Boolean getWriteIndex() {
        return this.isWriteIndex;
    }

    public static Builder builder(String alias) {
        return new Builder(alias);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Alias)) {
            return false;
        }
        Alias that = (Alias)o;
        return Objects.equals(this.alias, that.alias) && Objects.equals(this.filter, that.filter) && Objects.equals(this.indexRouting, that.indexRouting) && Objects.equals(this.searchRouting, that.searchRouting) && Objects.equals(this.routing, that.routing) && Objects.equals(this.isHidden, that.isHidden) && Objects.equals(this.isWriteIndex, that.isWriteIndex);
    }

    public int hashCode() {
        return Objects.hash(this.alias, this.filter, this.indexRouting, this.searchRouting, this.routing, this.isHidden, this.isWriteIndex);
    }

    public static class Builder {
        private final String alias;
        @Nullable
        private Query filter;
        @Nullable
        private String indexRouting;
        @Nullable
        private String searchRouting;
        @Nullable
        private String routing;
        @Nullable
        private Boolean isHidden;
        @Nullable
        private Boolean isWriteIndex;

        public Builder(String alias) {
            Assert.notNull((Object)alias, (String)"alias must not be null");
            this.alias = alias;
        }

        public Builder withFilter(@Nullable Query filter) {
            this.filter = filter;
            return this;
        }

        public Builder withIndexRouting(@Nullable String indexRouting) {
            if (indexRouting != null && !indexRouting.trim().isEmpty()) {
                this.indexRouting = indexRouting;
            }
            return this;
        }

        public Builder withSearchRouting(@Nullable String searchRouting) {
            if (searchRouting != null && !searchRouting.trim().isEmpty()) {
                this.searchRouting = searchRouting;
            }
            return this;
        }

        public Builder withRouting(@Nullable String routing) {
            if (routing != null && !routing.trim().isEmpty()) {
                this.routing = routing;
            }
            return this;
        }

        public Builder withHidden(@Nullable Boolean hidden) {
            this.isHidden = hidden;
            return this;
        }

        public Builder withWriteIndex(@Nullable Boolean writeIndex) {
            this.isWriteIndex = writeIndex;
            return this;
        }

        public Alias build() {
            return new Alias(this);
        }
    }
}

