/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.elasticsearch.core.index;

import org.springframework.data.elasticsearch.core.index.TemplateResponseData;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public record TemplateResponse(String name, @Nullable Long version, @Nullable TemplateResponseData templateData) {
    public TemplateResponse {
        Assert.notNull((Object)name, (String)"name must not be null");
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        @Nullable
        private String name;
        @Nullable
        private Long version;
        @Nullable
        private TemplateResponseData templateData;

        public Builder withName(String name) {
            this.name = name;
            return this;
        }

        public Builder withVersion(Long version) {
            this.version = version;
            return this;
        }

        public Builder withTemplateData(TemplateResponseData templateData) {
            this.templateData = templateData;
            return this;
        }

        public TemplateResponse build() {
            return new TemplateResponse(this.name, this.version, this.templateData);
        }
    }
}

