/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.elasticsearch.client;

import java.util.Set;
import org.springframework.data.elasticsearch.client.ElasticsearchHost;

public class NoReachableHostException
extends RuntimeException {
    public NoReachableHostException(Set<ElasticsearchHost> hosts) {
        super(NoReachableHostException.createMessage(hosts));
    }

    public NoReachableHostException(Set<ElasticsearchHost> hosts, Throwable cause) {
        super(NoReachableHostException.createMessage(hosts), cause);
    }

    private static String createMessage(Set<ElasticsearchHost> hosts) {
        if (hosts.size() == 1) {
            return String.format("Host '%s' not reachable. Cluster state is offline.", hosts.iterator().next().getEndpoint());
        }
        return String.format("No active host found in cluster. (%s) of (%s) nodes offline.", hosts.size(), hosts.size());
    }
}

