/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.elasticsearch.repository.query;

import java.util.Arrays;
import java.util.List;
import org.springframework.core.convert.ConversionService;
import org.springframework.data.elasticsearch.annotations.Highlight;
import org.springframework.data.elasticsearch.core.query.StringQuery;
import org.springframework.data.elasticsearch.core.query.highlight.HighlightField;
import org.springframework.data.elasticsearch.core.query.highlight.HighlightParameters;
import org.springframework.data.elasticsearch.repository.query.ElasticsearchParametersParameterAccessor;
import org.springframework.data.elasticsearch.repository.support.QueryStringProcessor;
import org.springframework.data.expression.ValueEvaluationContextProvider;
import org.springframework.data.repository.query.QueryMethod;
import org.springframework.util.Assert;

public class HighlightConverter {
    private final ElasticsearchParametersParameterAccessor parameterAccessor;
    private final ConversionService conversionService;
    private final ValueEvaluationContextProvider evaluationContextProvider;
    private final QueryMethod queryMethod;

    HighlightConverter(ElasticsearchParametersParameterAccessor parameterAccessor, ConversionService conversionService, ValueEvaluationContextProvider evaluationContextProvider, QueryMethod queryMethod) {
        Assert.notNull((Object)parameterAccessor, (String)"parameterAccessor must not be null");
        Assert.notNull((Object)conversionService, (String)"conversionService must not be null");
        Assert.notNull((Object)evaluationContextProvider, (String)"evaluationContextProvider must not be null");
        Assert.notNull((Object)queryMethod, (String)"queryMethod must not be null");
        this.parameterAccessor = parameterAccessor;
        this.conversionService = conversionService;
        this.evaluationContextProvider = evaluationContextProvider;
        this.queryMethod = queryMethod;
    }

    org.springframework.data.elasticsearch.core.query.highlight.Highlight convert(Highlight highlight) {
        Assert.notNull((Object)highlight, (String)"highlight must not be null");
        org.springframework.data.elasticsearch.annotations.HighlightParameters parameters = highlight.parameters();
        StringQuery highlightQuery = null;
        if (!parameters.highlightQuery().value().isEmpty()) {
            String rawQuery = parameters.highlightQuery().value();
            String query = new QueryStringProcessor(rawQuery, this.queryMethod, this.conversionService, this.evaluationContextProvider).createQuery(this.parameterAccessor);
            highlightQuery = new StringQuery(query);
        }
        HighlightParameters highlightParameters = ((HighlightParameters.HighlightParametersBuilder)((HighlightParameters.HighlightParametersBuilder)((HighlightParameters.HighlightParametersBuilder)((HighlightParameters.HighlightParametersBuilder)((HighlightParameters.HighlightParametersBuilder)((HighlightParameters.HighlightParametersBuilder)((HighlightParameters.HighlightParametersBuilder)((HighlightParameters.HighlightParametersBuilder)((HighlightParameters.HighlightParametersBuilder)((HighlightParameters.HighlightParametersBuilder)((HighlightParameters.HighlightParametersBuilder)((HighlightParameters.HighlightParametersBuilder)((HighlightParameters.HighlightParametersBuilder)((HighlightParameters.HighlightParametersBuilder)((HighlightParameters.HighlightParametersBuilder)((HighlightParameters.HighlightParametersBuilder)HighlightParameters.builder().withBoundaryChars(parameters.boundaryChars())).withBoundaryMaxScan(parameters.boundaryMaxScan())).withBoundaryScanner(parameters.boundaryScanner())).withBoundaryScannerLocale(parameters.boundaryScannerLocale())).withEncoder(parameters.encoder()).withForceSource(parameters.forceSource())).withFragmenter(parameters.fragmenter())).withFragmentSize(parameters.fragmentSize())).withNoMatchSize(parameters.noMatchSize())).withNumberOfFragments(parameters.numberOfFragments())).withHighlightQuery(highlightQuery)).withOrder(parameters.order())).withPhraseLimit(parameters.phraseLimit())).withPreTags(parameters.preTags())).withPostTags(parameters.postTags())).withRequireFieldMatch(parameters.requireFieldMatch())).withTagsSchema(parameters.tagsSchema()).withType(parameters.type())).build();
        List<HighlightField> highlightFields = Arrays.stream(highlight.fields()).map(HighlightField::of).toList();
        return new org.springframework.data.elasticsearch.core.query.highlight.Highlight(highlightParameters, highlightFields);
    }
}

