/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.elasticsearch.core.query;

import org.springframework.data.elasticsearch.core.query.Query;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class RescorerQuery {
    private final Query query;
    private ScoreMode scoreMode = ScoreMode.Default;
    @Nullable
    private Integer windowSize;
    @Nullable
    private Float queryWeight;
    @Nullable
    private Float rescoreQueryWeight;

    public RescorerQuery(Query query) {
        Assert.notNull((Object)query, (String)"query must not be null");
        this.query = query;
    }

    public Query getQuery() {
        return this.query;
    }

    public ScoreMode getScoreMode() {
        return this.scoreMode;
    }

    @Nullable
    public Integer getWindowSize() {
        return this.windowSize;
    }

    @Nullable
    public Float getQueryWeight() {
        return this.queryWeight;
    }

    @Nullable
    public Float getRescoreQueryWeight() {
        return this.rescoreQueryWeight;
    }

    public RescorerQuery withScoreMode(ScoreMode scoreMode) {
        Assert.notNull((Object)((Object)scoreMode), (String)"scoreMode must not be null");
        this.scoreMode = scoreMode;
        return this;
    }

    public RescorerQuery withWindowSize(int windowSize) {
        this.windowSize = windowSize;
        return this;
    }

    public RescorerQuery withQueryWeight(float queryWeight) {
        this.queryWeight = Float.valueOf(queryWeight);
        return this;
    }

    public RescorerQuery withRescoreQueryWeight(float rescoreQueryWeight) {
        this.rescoreQueryWeight = Float.valueOf(rescoreQueryWeight);
        return this;
    }

    public static enum ScoreMode {
        Default,
        Avg,
        Max,
        Min,
        Total,
        Multiply;

    }
}

